/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Timestamp;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.CategoryEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5206\u7c7b\u8868\u7ba1\u7406")
@Controller
@RequestMapping(value={"/${ms.manager.path}/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="query")})
    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        String modelTitle = BasicUtil.getString("modelTitle");
        int modelId = BasicUtil.getInt("modelId");
        if (modelId == 0) {
            String modelCode = BasicUtil.getString("modelCode");
            modelId = BasicUtil.getModelCodeId(modelCode);
        }
        model.addAttribute("modelTitle", (Object)modelTitle);
        model.addAttribute("modelId", (Object)modelId);
        return "/basic/category/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7c7b\u8868\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u7c7b\u522b\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u7c7b\u522b\u7684\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryDateTime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237\u7f16\u53f7(\u53d1\u5e03\u8005\u7f16\u53f7)", required=false, paramType="query"), @ApiImplicitParam(name="categoryModelId", value="\u6240\u5c5e\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryCategoryId", value="\u7236\u7c7b\u522b\u7684\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categorySmallImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryAppId", value="\u5206\u7c7b\u6240\u5c5e\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescription", value="\u680f\u76ee\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65e5\u671f", required=false, paramType="query"), @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="path")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        String modelId = request.getParameter("modelId");
        BasicUtil.setSession(SessionConstEnum.MANAGER_MODEL_CODE, (Object)modelId);
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        category.setCategoryModelId(Integer.parseInt(modelId));
        AppEntity app = this.getApp(request);
        category.setCategoryAppId(app.getAppId());
        if (managerSession.getManagerId() != app.getAppManagerId()) {
            category.setCategoryManagerId(managerSession.getManagerId());
        }
        BasicUtil.startPage();
        List categoryList = this.categoryBiz.query(category);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(categoryList, (int)BasicUtil.endPage(categoryList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter("yyyy-MM-dd HH:mm:ss")}));
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762form")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u7c7b\u522b\u7684\u7f16\u53f7\u81ea\u589e\u957fid", required=true, paramType="query"), @ApiImplicitParam(name="modelTitle", value="\u6a21\u5757\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="modelId", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="query")})
    @GetMapping(value={"/form"})
    public String form(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (category.getCategoryId() > 0) {
            BaseEntity categoryEntity = this.categoryBiz.getEntity(category.getCategoryId());
            model.addAttribute("categoryEntity", (Object)categoryEntity);
        }
        request.setAttribute("modelTitle", (Object)BasicUtil.getString("modelTitle"));
        request.setAttribute("modelId", (Object)BasicUtil.getInt("modelId"));
        return "/basic/category/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u8868")
    @ApiImplicitParam(name="categoryId", value="\u7c7b\u522b\u7684\u7f16\u53f7\u81ea\u589e\u957fid", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (category.getCategoryId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("category.id")}));
            return;
        }
        CategoryEntity _category = (CategoryEntity)this.categoryBiz.getEntity(category.getCategoryId());
        this.outJson(response, _category);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u8868\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u7c7b\u522b\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u7c7b\u522b\u7684\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryDateTime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237\u7f16\u53f7(\u53d1\u5e03\u8005\u7f16\u53f7)", required=false, paramType="query"), @ApiImplicitParam(name="categoryModelId", value="\u6240\u5c5e\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryCategoryId", value="\u7236\u7c7b\u522b\u7684\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categorySmallImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryAppId", value="\u5206\u7c7b\u6240\u5c5e\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescription", value="\u680f\u76ee\u63cf\u8ff0", required=true, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65e5\u671f", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank(category.getCategoryTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("category.title")}));
            return;
        }
        if (!StringUtil.checkLength(category.getCategoryTitle() + "", 1, 50)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "50"}));
            return;
        }
        if (!StringUtil.checkLength(category.getCategoryDescription() + "", 0, 45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.description"), "1", "45"}));
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        category.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
        category.setCategoryAppId(BasicUtil.getAppId());
        this.categoryBiz.saveEntity(category);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)category)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5206\u7c7b\u8868")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<CategoryEntity> categorys, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[categorys.size()];
        for (int i = 0; i < categorys.size(); ++i) {
            ids[i] = categorys.get(i).getCategoryId();
        }
        this.categoryBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u5206\u7c7b\u8868\u4fe1\u606f\u5206\u7c7b\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", value="\u7c7b\u522b\u7684\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryTitle", value="\u7c7b\u522b\u7684\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u7c7b\u522b\u7684\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryDateTime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237\u7f16\u53f7(\u53d1\u5e03\u8005\u7f16\u53f7)", required=false, paramType="query"), @ApiImplicitParam(name="categoryModelId", value="\u6240\u5c5e\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryCategoryId", value="\u7236\u7c7b\u522b\u7684\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categorySmallImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryAppId", value="\u5206\u7c7b\u6240\u5c5e\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescription", value="\u680f\u76ee\u63cf\u8ff0", required=true, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65e5\u671f", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank(category.getCategoryTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("category.title")}));
            return;
        }
        if (!StringUtil.checkLength(category.getCategoryTitle() + "", 1, 50)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "50"}));
            return;
        }
        if (!StringUtil.checkLength(category.getCategoryDescription() + "", 0, 45)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("category.description"), "1", "45"}));
            return;
        }
        category.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        this.categoryBiz.updateEntity(category);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)category)));
    }

    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u627e\u5206\u7c7b\u5b50\u5206\u7c7b")
    @ApiImplicitParam(name="categoryId", value="\u5206\u7c7bid", required=true, paramType="path")
    @GetMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable @ApiIgnore int categoryId, HttpServletRequest request, @ApiIgnore ModelMap mode, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
            this.outJson(response, JSONObject.toJSONString(list));
        }
    }
}

