/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang3.StringUtils;

public class TagsOverviewPage
extends AbstractPage {
    public static final String WEB_PAGE = "overview-tags.html";

    public TagsOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "overviewTags.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return WEB_PAGE;
    }

    @Override
    public void prepareReport() {
        List<TagObject> tags = this.reportResult.getAllTags();
        this.context.put("all_tags", tags);
        this.context.put("report_summary", (Object)this.reportResult.getTagReport());
        this.context.put("chart_categories", (Object)TagsOverviewPage.generateTagLabels(this.filterExcludedTags(tags)));
        this.context.put("chart_data", TagsOverviewPage.generateTagValues(this.filterExcludedTags(tags)));
    }

    static String generateTagLabels(List<TagObject> tagsObjectList) {
        int tagCount = tagsObjectList.size();
        Object[] tagNames = new String[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            tagNames[i] = StringUtils.wrap((String)tagsObjectList.get(i).getName(), (String)"\"");
        }
        return "[" + StringUtils.join((Object[])tagNames, (String)",") + "]";
    }

    private List<TagObject> filterExcludedTags(List<TagObject> tagsObjectList) {
        ArrayList<TagObject> filteredTags = new ArrayList<TagObject>();
        for (TagObject tagObject : tagsObjectList) {
            String tagName = tagObject.getName();
            if (!this.shouldIncludeTag(tagName)) continue;
            filteredTags.add(tagObject);
        }
        return filteredTags;
    }

    private boolean shouldIncludeTag(String tagName) {
        for (Pattern pattern : this.configuration.getTagsToExcludeFromChart()) {
            if (!tagName.matches(pattern.pattern())) continue;
            return false;
        }
        return true;
    }

    static List<String> generateTagValues(List<TagObject> tagsObjectList) {
        int tagsCount = tagsObjectList.size();
        String[][] values = new String[Status.values().length][tagsCount];
        for (int i = 0; i < tagsCount; ++i) {
            TagObject tagObject = tagsObjectList.get(i);
            int allSteps = tagObject.getSteps();
            values[0][i] = Util.formatAsDecimal(tagObject.getPassedSteps(), allSteps);
            values[1][i] = Util.formatAsDecimal(tagObject.getFailedSteps(), allSteps);
            values[2][i] = Util.formatAsDecimal(tagObject.getSkippedSteps(), allSteps);
            values[3][i] = Util.formatAsDecimal(tagObject.getPendingSteps(), allSteps);
            values[4][i] = Util.formatAsDecimal(tagObject.getUndefinedSteps(), allSteps);
        }
        ArrayList<String> statuses = new ArrayList<String>();
        for (int i = 0; i < Status.values().length; ++i) {
            statuses.add("[" + StringUtils.join((Object[])values[i], (String)", ") + "]");
        }
        return statuses;
    }
}

