/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import net.logstash.logback.argument.StructuredArguments;
import net.logstash.logback.marker.SingleFieldAppendingMarker;

public class ObjectAppendingMarker
extends SingleFieldAppendingMarker {
    public static final String MARKER_NAME = "LS_APPEND_OBJECT";
    private final Object fieldValue;

    public ObjectAppendingMarker(String fieldName, Object fieldValue) {
        super(MARKER_NAME, fieldName);
        this.fieldValue = fieldValue;
    }

    public ObjectAppendingMarker(String fieldName, Object fieldValue, String messageFormatPattern) {
        super(MARKER_NAME, fieldName, messageFormatPattern);
        this.fieldValue = fieldValue;
    }

    @Override
    protected void writeFieldValue(JsonGenerator generator) throws IOException {
        generator.writeObject(this.fieldValue);
    }

    @Override
    public Object getFieldValue() {
        return StructuredArguments.toString(this.fieldValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectAppendingMarker)) {
            return false;
        }
        ObjectAppendingMarker other = (ObjectAppendingMarker)obj;
        return Objects.equals(this.fieldValue, other.fieldValue);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.fieldValue == null ? 0 : this.fieldValue.hashCode());
        return result;
    }
}

