/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import net.logstash.logback.marker.LogstashMarker;

public abstract class SingleFieldAppendingMarker
extends LogstashMarker {
    public static final String MARKER_NAME_PREFIX = "LS_APPEND_";
    private final String fieldName;

    public SingleFieldAppendingMarker(String markerName, String fieldName) {
        super(markerName);
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void writeTo(JsonGenerator generator, ObjectMapper mapper) throws IOException {
        this.writeFieldName(generator);
        this.writeFieldValue(generator, mapper);
    }

    protected void writeFieldName(JsonGenerator generator) throws IOException {
        generator.writeFieldName(this.getFieldName());
    }

    protected abstract void writeFieldValue(JsonGenerator var1, ObjectMapper var2) throws IOException;

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SingleFieldAppendingMarker)) {
            return false;
        }
        SingleFieldAppendingMarker other = (SingleFieldAppendingMarker)((Object)obj);
        return this.fieldName.equals(other.fieldName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }
}

