/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Map;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;

public class LogstashAccessFormatter {
    private static final JsonFactory FACTORY = new MappingJsonFactory().enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final ThreadLocal<SoftReference<BufferRecycler>> recycler = new ThreadLocal<SoftReference<BufferRecycler>>(){

        @Override
        protected SoftReference<BufferRecycler> initialValue() {
            BufferRecycler bufferRecycler = new BufferRecycler();
            return new SoftReference<BufferRecycler>(bufferRecycler);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeValueAsBytes(IAccessEvent event, Context context) throws IOException {
        ByteArrayBuilder outputStream = new ByteArrayBuilder(this.getBufferRecycler());
        try {
            this.writeValueToOutputStream(event, context, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            outputStream.release();
        }
    }

    public void writeValueToOutputStream(IAccessEvent event, Context context, OutputStream outputStream) throws IOException {
        JsonGenerator generator = FACTORY.createGenerator(outputStream);
        this.writeValueToGenerator(generator, event, context);
    }

    public String writeValueAsString(IAccessEvent event, Context context) throws IOException {
        SegmentedStringWriter writer = new SegmentedStringWriter(this.getBufferRecycler());
        JsonGenerator generator = FACTORY.createGenerator((Writer)writer);
        this.writeValueToGenerator(generator, event, context);
        return writer.getAndClear();
    }

    private void writeValueToGenerator(JsonGenerator generator, IAccessEvent event, Context context) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        generator.writeNumberField("@version", 1);
        generator.writeStringField("@message", String.format("%s - %s [%s] \"%s\" %s %s", event.getRemoteHost(), event.getRemoteUser() == null ? "-" : event.getRemoteUser(), ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()), event.getRequestURL(), event.getStatusCode(), event.getContentLength()));
        this.writeFields(generator, event, context);
        generator.writeEndObject();
        generator.flush();
    }

    private void writeFields(JsonGenerator generator, IAccessEvent event, Context context) throws IOException {
        generator.writeStringField("@fields.method", event.getMethod());
        generator.writeStringField("@fields.protocol", event.getProtocol());
        generator.writeNumberField("@fields.status_code", event.getStatusCode());
        generator.writeStringField("@fields.requested_url", event.getRequestURL());
        generator.writeStringField("@fields.requested_uri", event.getRequestURI());
        generator.writeStringField("@fields.remote_host", event.getRemoteHost());
        generator.writeStringField("@fields.HOSTNAME", event.getRemoteHost());
        generator.writeStringField("@fields.remote_user", event.getRemoteUser());
        generator.writeNumberField("@fields.content_length", event.getContentLength());
        generator.writeNumberField("@fields.elapsed_time", event.getElapsedTime());
        this.writeContextPropertiesIfNecessary(generator, context);
    }

    private void writeContextPropertiesIfNecessary(JsonGenerator generator, Context context) throws IOException {
        if (context != null) {
            this.writeMapEntries(generator, context.getCopyOfPropertyMap());
        }
    }

    private void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonGenerationException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                MAPPER.writeValue(generator, entry.getValue());
            }
        }
    }

    private BufferRecycler getBufferRecycler() {
        SoftReference<BufferRecycler> bufferRecyclerReference = this.recycler.get();
        BufferRecycler bufferRecycler = bufferRecyclerReference.get();
        if (bufferRecycler == null) {
            this.recycler.remove();
            return this.getBufferRecycler();
        }
        return bufferRecycler;
    }
}

