/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import java.io.IOException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.ObjectMapper;
import net.logstash.logback.encoder.org.apache.commons.lang.ObjectUtils;
import net.logstash.logback.marker.SingleFieldAppendingMarker;

public class RawJsonAppendingMarker
extends SingleFieldAppendingMarker {
    public static final String MARKER_NAME = "LS_APPEND_RAW";
    private final String rawJson;

    public RawJsonAppendingMarker(String fieldName, String rawJson) {
        super(MARKER_NAME, fieldName);
        if (rawJson == null) {
            throw new IllegalArgumentException("rawJson must not be null");
        }
        this.rawJson = rawJson;
    }

    @Override
    protected void writeFieldValue(JsonGenerator generator, ObjectMapper mapper) throws IOException {
        generator.writeRawValue(this.rawJson);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RawJsonAppendingMarker)) {
            return false;
        }
        RawJsonAppendingMarker other = (RawJsonAppendingMarker)((Object)obj);
        return ObjectUtils.equals(this.rawJson, other.rawJson);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.rawJson.hashCode();
        return result;
    }
}

