/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParser;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonProcessingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonToken;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.BeanProperty;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationFeature;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JavaType;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JsonMappingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.type.TypeFactory;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.util.ClassUtil;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.util.ObjectBuffer;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer,
ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_OBJECTS = new Object[0];
    @Deprecated
    public static final UntypedObjectDeserializer instance = new UntypedObjectDeserializer();
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;

    public UntypedObjectDeserializer() {
        super(Object.class);
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        super(Object.class);
        this._mapDeserializer = jsonDeserializer;
        this._listDeserializer = jsonDeserializer2;
        this._stringDeserializer = jsonDeserializer3;
        this._numberDeserializer = jsonDeserializer4;
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        JavaType javaType = deserializationContext.constructType(Object.class);
        JavaType javaType2 = deserializationContext.constructType(String.class);
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        this._mapDeserializer = this._findCustomDeser(deserializationContext, typeFactory.constructMapType(Map.class, javaType2, javaType));
        this._listDeserializer = this._findCustomDeser(deserializationContext, typeFactory.constructCollectionType(List.class, javaType));
        this._stringDeserializer = this._findCustomDeser(deserializationContext, javaType2);
        this._numberDeserializer = this._findCustomDeser(deserializationContext, typeFactory.constructType((Type)((Object)Number.class)));
    }

    protected JsonDeserializer<Object> _findCustomDeser(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (ClassUtil.isJacksonStdImpl(jsonDeserializer)) {
            return null;
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2;
        JsonDeserializer<Object> jsonDeserializer3;
        JsonDeserializer<Object> jsonDeserializer4 = this._mapDeserializer;
        if (jsonDeserializer4 instanceof ContextualDeserializer) {
            jsonDeserializer4 = ((ContextualDeserializer)((Object)jsonDeserializer4)).createContextual(deserializationContext, beanProperty);
        }
        if ((jsonDeserializer3 = this._listDeserializer) instanceof ContextualDeserializer) {
            jsonDeserializer3 = ((ContextualDeserializer)((Object)jsonDeserializer3)).createContextual(deserializationContext, beanProperty);
        }
        if ((jsonDeserializer2 = this._stringDeserializer) instanceof ContextualDeserializer) {
            jsonDeserializer2 = ((ContextualDeserializer)((Object)jsonDeserializer2)).createContextual(deserializationContext, beanProperty);
        }
        if ((jsonDeserializer = this._numberDeserializer) instanceof ContextualDeserializer) {
            jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(deserializationContext, beanProperty);
        }
        if (jsonDeserializer4 != this._mapDeserializer || jsonDeserializer3 != this._listDeserializer || jsonDeserializer2 != this._stringDeserializer || jsonDeserializer != this._numberDeserializer) {
            return this._withResolved(jsonDeserializer4, jsonDeserializer3, jsonDeserializer2, jsonDeserializer);
        }
        return this;
    }

    protected JsonDeserializer<?> _withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        return new UntypedObjectDeserializer(this, jsonDeserializer, jsonDeserializer2, jsonDeserializer3, jsonDeserializer4);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getCurrentToken()) {
            case FIELD_NAME: 
            case START_OBJECT: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case START_ARRAY: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jsonParser.getEmbeddedObject();
            }
            case VALUE_STRING: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getNumberValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw deserializationContext.mappingException(Object.class);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        switch (jsonToken) {
            case FIELD_NAME: 
            case START_OBJECT: 
            case START_ARRAY: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            case VALUE_STRING: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getNumberValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jsonParser.getEmbeddedObject();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw deserializationContext.mappingException(Object.class);
    }

    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ArrayList<Object> arrayList;
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return new ArrayList(4);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        int n2 = 0;
        do {
            arrayList = this.deserialize(jsonParser, deserializationContext);
            ++n2;
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = arrayList;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        arrayList = new ArrayList<Object>(n2 + (n2 >> 3) + 1);
        objectBuffer.completeAndClearBuffer(objectArray, n, arrayList);
        return arrayList;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        }
        if (jsonToken != JsonToken.FIELD_NAME) {
            return new LinkedHashMap(4);
        }
        String string = jsonParser.getText();
        jsonParser.nextToken();
        Object object = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put(string, object);
            return linkedHashMap;
        }
        String string2 = jsonParser.getText();
        jsonParser.nextToken();
        Object object2 = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put(string, object);
            linkedHashMap.put(string2, object2);
            return linkedHashMap;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(string, object);
        linkedHashMap.put(string2, object2);
        do {
            String string3 = jsonParser.getText();
            jsonParser.nextToken();
            linkedHashMap.put(string3, this.deserialize(jsonParser, deserializationContext));
        } while (jsonParser.nextToken() != JsonToken.END_OBJECT);
        return linkedHashMap;
    }

    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        do {
            Object object = this.deserialize(jsonParser, deserializationContext);
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return objectBuffer.completeAndClearBuffer(objectArray, n);
    }
}

