/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import net.logstash.logback.LogstashAccessFormatter;
import net.logstash.logback.encoder.org.apache.commons.io.IOUtils;

public class LogstashAccessEncoder
extends EncoderBase<IAccessEvent> {
    private boolean immediateFlush = true;
    private final LogstashAccessFormatter formatter = new LogstashAccessFormatter();

    public void doEncode(IAccessEvent event) throws IOException {
        IOUtils.write(this.formatter.writeValueAsBytes(event, this.getContext()), this.outputStream);
        IOUtils.write(CoreConstants.LINE_SEPARATOR, this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        IOUtils.write(IOUtils.LINE_SEPARATOR, this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }
}

