/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Marker;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    private static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final StackTraceElement DEFAULT_CALLER_DATA = new StackTraceElement("", "", "", 0);
    private boolean immediateFlush = true;
    private boolean includeCallerInfo = true;

    public void doEncode(ILoggingEvent event) throws IOException {
        ObjectNode eventNode = MAPPER.createObjectNode();
        eventNode.put("@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        eventNode.put("@message", event.getFormattedMessage());
        eventNode.put("@fields", (JsonNode)this.createFields(event));
        eventNode.put("@tags", (JsonNode)this.createTags(event));
        IOUtils.write((byte[])MAPPER.writeValueAsBytes((Object)eventNode), (OutputStream)this.outputStream);
        IOUtils.write((String)CoreConstants.LINE_SEPARATOR, (OutputStream)this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    private ObjectNode createFields(ILoggingEvent event) {
        Context context;
        IThrowableProxy throwableProxy;
        ObjectNode fieldsNode = MAPPER.createObjectNode();
        fieldsNode.put("logger_name", event.getLoggerName());
        fieldsNode.put("thread_name", event.getThreadName());
        fieldsNode.put("level", event.getLevel().toString());
        fieldsNode.put("level_value", event.getLevel().toInt());
        if (this.includeCallerInfo) {
            StackTraceElement callerData = this.extractCallerData(event);
            fieldsNode.put("caller_class_name", callerData.getClassName());
            fieldsNode.put("caller_method_name", callerData.getMethodName());
            fieldsNode.put("caller_file_name", callerData.getFileName());
            fieldsNode.put("caller_line_number", callerData.getLineNumber());
        }
        if ((throwableProxy = event.getThrowableProxy()) != null) {
            fieldsNode.put("stack_trace", ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
        }
        if ((context = this.getContext()) != null) {
            this.addPropertiesAsFields(fieldsNode, context.getCopyOfPropertyMap());
        }
        this.addPropertiesAsFields(fieldsNode, event.getMDCPropertyMap());
        return fieldsNode;
    }

    private ArrayNode createTags(ILoggingEvent event) {
        ArrayNode node = null;
        Marker marker = event.getMarker();
        if (marker != null) {
            node = MAPPER.createArrayNode();
            node.add(marker.getName());
            if (marker.hasReferences()) {
                for (Marker next : event.getMarker()) {
                    node.add(next.getName());
                }
            }
        }
        return node;
    }

    private void addPropertiesAsFields(ObjectNode fieldsNode, Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                fieldsNode.put(key, value);
            }
        }
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return DEFAULT_CALLER_DATA;
        }
        return ste[0];
    }

    public void close() throws IOException {
        IOUtils.write((String)IOUtils.LINE_SEPARATOR, (OutputStream)this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isIncludeCallerInfo() {
        return this.includeCallerInfo;
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }
}

