/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExpirableMap<K, V>
extends ConcurrentHashMap<K, V> {
    public static final int DEFAULT_CHECK_INTERVAL = 600;
    public static final int DEFAULT_TTL = 1800;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private final long ttl;
    private final Map<K, Long> expires;
    private final OnExpire<V> onExpire;

    public ExpirableMap(int ttl, int checkInterval, OnExpire<V> onExpire) {
        this.ttl = ttl * 1000;
        this.onExpire = onExpire;
        this.expires = new HashMap<K, Long>();
        this.scheduler.scheduleWithFixedDelay(new Worker(), checkInterval, checkInterval, TimeUnit.SECONDS);
    }

    public ExpirableMap(int ttl, OnExpire<V> onExpire) {
        this(ttl, 600, onExpire);
    }

    public ExpirableMap(OnExpire<V> onExpire) {
        this(1800, 600, onExpire);
    }

    public ExpirableMap() {
        this(1800, 600, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        ExpirableMap expirableMap = this;
        synchronized (expirableMap) {
            this.expires.put(key, new Date().getTime() + this.ttl);
            return super.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ExpirableMap expirableMap = this;
        synchronized (expirableMap) {
            this.expires.put(key, new Date().getTime() + this.ttl);
            return super.put(key, value);
        }
    }

    public static interface OnExpire<V> {
        public void run(V var1);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap m;
            ExpirableMap expirableMap = ExpirableMap.this;
            synchronized (expirableMap) {
                m = new HashMap(ExpirableMap.this.expires);
            }
            Long now = new Date().getTime();
            for (Map.Entry e : m.entrySet()) {
                if ((Long)e.getValue() > now) continue;
                ExpirableMap expirableMap2 = ExpirableMap.this;
                synchronized (expirableMap2) {
                    Long expire = (Long)ExpirableMap.this.expires.get(e.getKey());
                    if (expire == null) {
                        continue;
                    }
                    if (expire <= new Date().getTime()) {
                        ExpirableMap.this.expires.remove(e.getKey());
                        Object v = ExpirableMap.this.remove(e.getKey());
                        if (v != null && ExpirableMap.this.onExpire != null) {
                            ExpirableMap.this.onExpire.run(v);
                        }
                    }
                }
            }
        }
    }
}

