/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet;

import net.lightbody.bmp.proxy.jetty.jetty.servlet.WebApplicationContext;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.xml.XmlConfiguration;
import org.apache.commons.logging.Log;

public class JettyWebConfiguration
implements WebApplicationContext.Configuration {
    private static Log log = LogFactory.getLog(JettyWebConfiguration.class);
    private WebApplicationContext _context;

    @Override
    public void setWebApplicationContext(WebApplicationContext context) {
        this._context = context;
    }

    @Override
    public WebApplicationContext getWebApplicationContext() {
        return this._context;
    }

    @Override
    public void configureClassPath() throws Exception {
    }

    @Override
    public void configureDefaults() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureWebApp() throws Exception {
        Resource webInf;
        if (this._context.isStarted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot configure webapp after it is started");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring web-jetty.xml");
        }
        if ((webInf = this.getWebApplicationContext().getWebInf()) != null && webInf.isDirectory()) {
            Resource jetty = webInf.addPath("web-jetty.xml");
            if (!jetty.exists()) {
                jetty = webInf.addPath("jetty-web.xml");
            }
            if (!this.getWebApplicationContext().isIgnoreWebJetty() && jetty.exists()) {
                String[] old_server_classes = this._context.getServerClasses();
                String[] server_classes = new String[1 + (old_server_classes == null ? 0 : old_server_classes.length)];
                server_classes[0] = "-net.lightbody.bmp.proxy.jetty.";
                if (server_classes != null) {
                    System.arraycopy(old_server_classes, 0, server_classes, 1, old_server_classes.length);
                }
                try {
                    this._context.setServerClasses(server_classes);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Configure: " + jetty));
                    }
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure(this.getWebApplicationContext());
                }
                finally {
                    if (this._context.getServerClasses() == server_classes) {
                        this._context.setServerClasses(old_server_classes);
                    }
                }
            }
        }
    }
}

