/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import net.lightbody.bmp.proxy.jetty.http.HttpConnection;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpFields;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpTunnel;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.LineInput;
import net.lightbody.bmp.proxy.jetty.util.LogSupport;
import net.lightbody.bmp.proxy.jetty.util.StringMap;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.apache.commons.logging.Log;

public class ProxyHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ProxyHandler.class);
    protected Set _proxyHostsWhiteList;
    protected Set _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 250;
    private boolean _anonymous = false;
    private transient boolean _chained = false;
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxyAuthHeaders;
    protected StringMap _ProxySchemes;
    protected HashSet _allowedConnectPorts;

    public ProxyHandler() {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Upgrade", o);
        this._ProxyAuthHeaders = new StringMap();
        o = new Object();
        this._ProxyAuthHeaders.put("Proxy-Authorization", o);
        this._ProxyAuthHeaders.put("Proxy-Authenticate", o);
        this._ProxySchemes = new StringMap();
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this._allowedConnectPorts = new HashSet();
        this._allowedConnectPorts.add(new Integer(80));
        this._allowedConnectPorts.add(new Integer(8000));
        this._allowedConnectPorts.add(new Integer(8080));
        this._allowedConnectPorts.add(new Integer(8888));
        this._allowedConnectPorts.add(new Integer(443));
        this._allowedConnectPorts.add(new Integer(8443));
    }

    @Override
    public void start() throws Exception {
        this._chained = System.getProperty("http.proxyHost") != null;
        super.start();
    }

    public String[] getProxyHostsWhiteList() {
        if (this._proxyHostsWhiteList == null || this._proxyHostsWhiteList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsWhiteList.size()];
        hosts = this._proxyHostsWhiteList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsWhiteList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsWhiteList = null;
        } else {
            this._proxyHostsWhiteList = new HashSet();
            for (int i = 0; i < hosts.length; ++i) {
                if (hosts[i] == null || hosts[i].trim().length() <= 0) continue;
                this._proxyHostsWhiteList.add(hosts[i]);
            }
        }
    }

    public String[] getProxyHostsBlackList() {
        if (this._proxyHostsBlackList == null || this._proxyHostsBlackList.size() == 0) {
            return new String[0];
        }
        String[] hosts = new String[this._proxyHostsBlackList.size()];
        hosts = this._proxyHostsBlackList.toArray(hosts);
        return hosts;
    }

    public void setProxyHostsBlackList(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            this._proxyHostsBlackList = null;
        } else {
            this._proxyHostsBlackList = new HashSet();
            for (int i = 0; i < hosts.length; ++i) {
                if (hosts[i] == null || hosts[i].trim().length() <= 0) continue;
                this._proxyHostsBlackList.add(hosts[i]);
            }
        }
    }

    public int getTunnelTimeoutMs() {
        return this._tunnelTimeoutMs;
    }

    public void setTunnelTimeoutMs(int ms) {
        this._tunnelTimeoutMs = ms;
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block25: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                response.setField("Connection", "close");
                this.handleConnect(pathInContext, pathParams, request, response);
                return;
            }
            try {
                String cache_control;
                String connectionHdr;
                URL url = this.isProxied(uri);
                if (url == null) {
                    if (this.isForbidden(uri)) {
                        this.sendForbid(request, response, uri);
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PROXY URL=" + url));
                }
                URLConnection connection = url.openConnection();
                connection.setAllowUserInteraction(false);
                HttpURLConnection http = null;
                if (connection instanceof HttpURLConnection) {
                    http = (HttpURLConnection)connection;
                    http.setRequestMethod(request.getMethod());
                    http.setInstanceFollowRedirects(false);
                }
                if ((connectionHdr = request.getField("Connection")) != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
                    connectionHdr = null;
                }
                boolean xForwardedFor = false;
                boolean hasContent = false;
                Enumeration enm = request.getFieldNames();
                while (enm.hasMoreElements()) {
                    String hdr = (String)enm.nextElement();
                    if (this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr) || connectionHdr != null && connectionHdr.indexOf(hdr) >= 0) continue;
                    if ("Content-Type".equals(hdr)) {
                        hasContent = true;
                    }
                    Enumeration vals = request.getFieldValues(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        connection.addRequestProperty(hdr, val);
                        xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                    }
                }
                if (!this._anonymous) {
                    connection.setRequestProperty("Via", "1.1 (jetty)");
                }
                if (!xForwardedFor) {
                    connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
                }
                if ((cache_control = request.getField("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                    connection.setUseCaches(false);
                }
                this.customizeConnection(pathInContext, pathParams, request, connection);
                try {
                    connection.setDoInput(true);
                    InputStream in = request.getInputStream();
                    if (hasContent) {
                        connection.setDoOutput(true);
                        IO.copy(in, connection.getOutputStream());
                    }
                    connection.connect();
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
                InputStream proxy_in = null;
                int code = 500;
                if (http != null) {
                    proxy_in = http.getErrorStream();
                    code = http.getResponseCode();
                    response.setStatus(code);
                    response.setReason(http.getResponseMessage());
                }
                if (proxy_in == null) {
                    try {
                        proxy_in = connection.getInputStream();
                    }
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                        proxy_in = http.getErrorStream();
                    }
                }
                response.removeField("Date");
                response.removeField("Server");
                int h = 0;
                String hdr = connection.getHeaderFieldKey(h);
                String val = connection.getHeaderField(h);
                while (hdr != null || val != null) {
                    if (!(hdr == null || val == null || this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr))) {
                        response.addField(hdr, val);
                    }
                    hdr = connection.getHeaderFieldKey(++h);
                    val = connection.getHeaderField(h);
                }
                if (!this._anonymous) {
                    response.setField("Via", "1.1 (jetty)");
                }
                request.setHandled(true);
                if (proxy_in != null) {
                    IO.copy(proxy_in, response.getOutputStream());
                }
            }
            catch (Exception e) {
                log.warn((Object)e.toString());
                LogSupport.ignore(log, e);
                if (response.isCommitted()) break block25;
                response.sendError(400);
            }
        }
    }

    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        URI uri = request.getURI();
        try {
            InetAddrPort addrPort;
            if (log.isDebugEnabled()) {
                log.debug((Object)("CONNECT: " + uri));
            }
            if (this.isForbidden("https", (addrPort = new InetAddrPort(uri.toString())).getHost(), addrPort.getPort(), false)) {
                this.sendForbid(request, response, uri);
            } else {
                HttpTunnel tunnel;
                HttpConnection http_connection = request.getHttpConnection();
                http_connection.forceClose();
                int timeoutMs = 30000;
                Object maybesocket = http_connection.getConnection();
                if (maybesocket instanceof Socket) {
                    Socket s = (Socket)maybesocket;
                    timeoutMs = s.getSoTimeout();
                }
                if ((tunnel = this.newHttpTunnel(request, response, addrPort.getInetAddress(), addrPort.getPort(), timeoutMs)) != null) {
                    if (this._tunnelTimeoutMs > 0) {
                        tunnel.getSocket().setSoTimeout(this._tunnelTimeoutMs);
                        if (maybesocket instanceof Socket) {
                            Socket s = (Socket)maybesocket;
                            s.setSoTimeout(this._tunnelTimeoutMs);
                        }
                    }
                    tunnel.setTimeoutMs(timeoutMs);
                    this.customizeConnection(pathInContext, pathParams, request, tunnel.getSocket());
                    request.getHttpConnection().setHttpTunnel(tunnel);
                    response.setStatus(200);
                    response.setContentLength(0);
                }
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
            response.sendError(500);
        }
    }

    protected HttpTunnel newHttpTunnel(HttpRequest request, HttpResponse response, InetAddress iaddr, int port, int timeoutMS) throws IOException {
        try {
            Socket socket = null;
            LineInput in = null;
            String chained_proxy_host = System.getProperty("http.proxyHost");
            if (chained_proxy_host == null) {
                socket = new Socket(iaddr, port);
                socket.setSoTimeout(timeoutMS);
                socket.setTcpNoDelay(true);
            } else {
                int space1;
                int chained_proxy_port = Integer.getInteger("http.proxyPort", 8888);
                Socket chain_socket = new Socket(chained_proxy_host, chained_proxy_port);
                chain_socket.setSoTimeout(timeoutMS);
                chain_socket.setTcpNoDelay(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("chain proxy socket=" + chain_socket));
                }
                LineInput line_in = new LineInput(chain_socket.getInputStream());
                byte[] connect = request.toString().getBytes(StringUtil.__ISO_8859_1);
                chain_socket.getOutputStream().write(connect);
                String chain_response_line = line_in.readLine();
                HttpFields chain_response = new HttpFields();
                chain_response.read(line_in);
                int space0 = chain_response_line.indexOf(32);
                if (space0 > 0 && space0 + 1 < chain_response_line.length() && (space1 = chain_response_line.indexOf(32, space0 + 1)) > space0) {
                    int code = Integer.parseInt(chain_response_line.substring(space0 + 1, space1));
                    if (code >= 200 && code < 300) {
                        socket = chain_socket;
                        in = line_in;
                    } else {
                        Enumeration iter = chain_response.getFieldNames();
                        while (iter.hasMoreElements()) {
                            String name = (String)iter.nextElement();
                            if (this._DontProxyHeaders.containsKey(name)) continue;
                            Enumeration values = chain_response.getValues(name);
                            while (values.hasMoreElements()) {
                                String value = (String)values.nextElement();
                                response.setField(name, value);
                            }
                        }
                        response.sendError(code);
                        if (!chain_socket.isClosed()) {
                            chain_socket.close();
                        }
                    }
                }
            }
            if (socket == null) {
                return null;
            }
            HttpTunnel tunnel = new HttpTunnel(socket, in, null);
            return tunnel;
        }
        catch (IOException e) {
            log.debug((Object)e);
            response.sendError(400);
            return null;
        }
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, Socket socket) throws IOException {
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, URLConnection connection) throws IOException {
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        if (this.isForbidden(uri)) {
            return null;
        }
        return new URL(uri.toString());
    }

    protected boolean isForbidden(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return this.isForbidden(scheme, host, port, true);
    }

    protected boolean isForbidden(String scheme, String host, int port, boolean openNonPrivPorts) {
        Integer p = new Integer(port);
        if (!(port <= 0 || this._allowedConnectPorts.contains(p) || openNonPrivPorts && port > 1024)) {
            return true;
        }
        if (scheme == null || !this._ProxySchemes.containsKey(scheme)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(host)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(host);
    }

    protected void sendForbid(HttpRequest request, HttpResponse response, URI uri) throws IOException {
        response.sendError(403, "Forbidden for Proxy");
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }
}

