/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.http.handler;

import java.io.IOException;
import java.io.OutputStream;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpHandler;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.log.LogFactory;
import net.lightbody.bmp.proxy.jetty.util.ByteArrayISO8859Writer;
import org.apache.commons.logging.Log;

public abstract class AbstractHttpHandler
implements HttpHandler {
    private static Log log = LogFactory.getLog(AbstractHttpHandler.class);
    private String _name;
    private transient HttpContext _context;
    private transient boolean _started = false;

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!log.isDebugEnabled()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    @Override
    public HttpContext getHttpContext() {
        return this._context;
    }

    @Override
    public void initialize(HttpContext context) {
        if (this._context == null) {
            this._context = context;
        } else if (this._context != context) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
    }

    @Override
    public void start() throws Exception {
        if (this._context == null) {
            throw new IllegalStateException("No context for " + this);
        }
        this._started = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + this));
        }
    }

    @Override
    public void stop() throws InterruptedException {
        this._started = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopped " + this));
        }
    }

    @Override
    public boolean isStarted() {
        return this._started;
    }

    public String toString() {
        return this.getName() + " in " + this._context;
    }

    public void handleTrace(HttpRequest request, HttpResponse response) throws IOException {
        boolean trace = this.getHttpContext().getHttpServer().getTrace();
        response.setField("Content-Type", "message/http");
        if (trace) {
            OutputStream out = response.getOutputStream();
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
            writer.write(request.toString());
            writer.flush();
            response.setIntField("Content-Length", writer.size());
            writer.writeTo(out);
            out.flush();
        }
        request.setHandled(true);
    }
}

