/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.lightbody.bmp.proxy.guice.NamedImpl;

public class ConfigModule
implements Module {
    private String[] args;

    public ConfigModule(String[] args) {
        this.args = args;
    }

    public void configure(Binder binder) {
        Integer maxPort;
        Integer minPort;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec portSpec = parser.accepts("port", "The port to listen on").withOptionalArg().ofType(Integer.class).defaultsTo((Object)8080, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec addressSpec = parser.accepts("address", "The address to bind to").withOptionalArg().ofType(String.class).defaultsTo((Object)"0.0.0.0", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec proxyPortRange = parser.accepts("proxyPortRange", "The range of ports to use for proxies").withOptionalArg().ofType(Integer.class).defaultsTo((Object)8081, (Object[])new Integer[]{8581}).withValuesSeparatedBy('-');
        ArgumentAcceptingOptionSpec ttlSpec = parser.accepts("ttl", "Time in seconds until an unused proxy is deleted").withOptionalArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        parser.acceptsAll(Arrays.asList("help", "?"), "This help text");
        OptionSet options = parser.parse(this.args);
        if (options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        List ports = options.valuesOf((OptionSpec)proxyPortRange);
        if (ports.size() < 2) {
            throw new IllegalArgumentException();
        }
        if ((Integer)ports.get(1) > (Integer)ports.get(0)) {
            minPort = (Integer)ports.get(0);
            maxPort = (Integer)ports.get(1);
        } else {
            minPort = (Integer)ports.get(1);
            maxPort = (Integer)ports.get(0);
        }
        Integer port = (Integer)portSpec.value(options);
        if (port >= minPort && port <= maxPort) {
            int num = maxPort - minPort;
            minPort = port + 1;
            maxPort = minPort + num;
        }
        binder.bind(Key.get(Integer.class, (Annotation)((Object)new NamedImpl("port")))).toInstance((Object)port);
        binder.bind(Key.get(String.class, (Annotation)((Object)new NamedImpl("address")))).toInstance(addressSpec.value(options));
        binder.bind(Key.get(Integer.class, (Annotation)((Object)new NamedImpl("minPort")))).toInstance((Object)minPort);
        binder.bind(Key.get(Integer.class, (Annotation)((Object)new NamedImpl("maxPort")))).toInstance((Object)maxPort);
        binder.bind(Key.get(Integer.class, (Annotation)((Object)new NamedImpl("ttl")))).toInstance(ttlSpec.value(options));
    }
}

