/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.lightbody.bmp.proxy.ProxyExistsException;
import net.lightbody.bmp.proxy.ProxyPortsExhaustedException;
import net.lightbody.bmp.proxy.ProxyServer;
import net.lightbody.bmp.proxy.util.ExpirableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProxyManager {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyManager.class);
    private int lastPort;
    private final int minPort;
    private final int maxPort;
    private final Provider<ProxyServer> proxyServerProvider;
    private final ConcurrentMap<Integer, ProxyServer> proxies;

    @Inject
    public ProxyManager(Provider<ProxyServer> proxyServerProvider, @Named(value="minPort") Integer minPort, @Named(value="maxPort") Integer maxPort, @Named(value="ttl") Integer ttl) {
        this.proxyServerProvider = proxyServerProvider;
        this.minPort = minPort;
        this.maxPort = maxPort;
        this.lastPort = maxPort;
        this.proxies = ttl > 0 ? new ExpirableMap((int)ttl, new ExpirableMap.OnExpire<ProxyServer>(){

            @Override
            public void run(ProxyServer proxy) {
                try {
                    LOG.debug("Expiring ProxyServer `{}`...", (Object)proxy.getPort());
                    proxy.stop();
                }
                catch (Exception ex) {
                    LOG.warn("Error while stopping an expired proxy", (Throwable)ex);
                }
            }
        }) : new ConcurrentHashMap();
    }

    public ProxyServer create(Map<String, String> options, Integer port, String bindAddr) {
        LOG.debug("Instantiate ProxyServer...");
        ProxyServer proxy = (ProxyServer)this.proxyServerProvider.get();
        LOG.debug("Apply options `{}` to new ProxyServer...", options);
        proxy.setOptions(options);
        if (bindAddr != null) {
            InetAddress inetAddress;
            LOG.debug("Bind ProxyServer to `{}`...", (Object)bindAddr);
            try {
                inetAddress = InetAddress.getByName(bindAddr);
            }
            catch (UnknownHostException e) {
                LOG.error("Unable to bind proxy to address: " + bindAddr + "; proxy will not be created.", (Throwable)e);
                throw new RuntimeException("Unable to bind proxy to address: ", e);
            }
            proxy.setLocalHost(inetAddress);
        }
        if (port != null) {
            return this.startProxy(proxy, port);
        }
        while (this.proxies.size() <= this.maxPort - this.minPort) {
            LOG.debug("Use next available port for new ProxyServer...");
            port = this.nextPort();
            try {
                return this.startProxy(proxy, port);
            }
            catch (ProxyExistsException ex) {
                LOG.debug("Proxy already exists at port {}", (Object)port);
            }
        }
        throw new ProxyPortsExhaustedException();
    }

    public ProxyServer create(Map<String, String> options, Integer port) {
        return this.create(options, port, null);
    }

    public ProxyServer create(Map<String, String> options) {
        return this.create(options, null, null);
    }

    public ProxyServer get(int port) {
        return (ProxyServer)this.proxies.get(port);
    }

    private ProxyServer startProxy(ProxyServer proxy, int port) {
        proxy.setPort(port);
        ProxyServer old = this.proxies.putIfAbsent(port, proxy);
        if (old != null) {
            LOG.info("Proxy already exists at port {}", (Object)port);
            throw new ProxyExistsException(port);
        }
        try {
            proxy.start();
            return proxy;
        }
        catch (Exception ex) {
            this.proxies.remove(port);
            try {
                proxy.stop();
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private synchronized int nextPort() {
        return this.lastPort < this.maxPort ? (this.lastPort = this.lastPort + 1) : (this.lastPort = this.minPort);
    }

    public Collection<ProxyServer> get() {
        return this.proxies.values();
    }

    public void delete(int port) {
        ProxyServer proxy = (ProxyServer)this.proxies.remove(port);
        proxy.stop();
    }
}

