/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.sitebricks.SitebricksModule;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import net.lightbody.bmp.exception.JettyException;
import net.lightbody.bmp.proxy.bricks.ProxyResource;
import net.lightbody.bmp.proxy.guice.ConfigModule;
import net.lightbody.bmp.proxy.guice.JettyModule;
import net.lightbody.bmp.proxy.util.StandardFormatter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String LOGGING_PROPERTIES_FILENAME = "conf/bmp-logging.properties";
    private static final String VERSION_PROP = "/version.prop";
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static String VERSION = null;

    public static void main(String[] args) {
        Main.configureJdkLogging();
        final Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(args), new JettyModule(), new SitebricksModule(){

            protected void configureSitebricks() {
                this.scan(ProxyResource.class.getPackage());
            }
        }});
        LOG.info("Starting BrowserMob Proxy version {}", (Object)Main.getVersion());
        Server server = (Server)injector.getInstance(Server.class);
        GuiceServletContextListener gscl = new GuiceServletContextListener(){

            protected Injector getInjector() {
                return injector;
            }
        };
        try {
            server.start();
        }
        catch (Exception e) {
            LOG.error("Failed to start Jetty server. Aborting.", (Throwable)e);
            throw new JettyException("Unable to start Jetty server", e);
        }
        ServletContextHandler context = (ServletContextHandler)server.getHandler();
        gscl.contextInitialized(new ServletContextEvent((ServletContext)context.getServletContext()));
        try {
            server.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getVersion() {
        if (VERSION == null) {
            String version = "UNKNOWN/DEVELOPMENT";
            InputStream is = Main.class.getResourceAsStream(VERSION_PROP);
            if (is != null) {
                Properties props = new Properties();
                try {
                    props.load(is);
                    version = props.getProperty("version");
                }
                catch (IOException e) {
                    Log.warn((String)"Unable to load properties file in /version.prop; version will not be set.", (Throwable)e);
                }
            }
            VERSION = version;
        }
        return VERSION;
    }

    static void configureJdkLogging() {
        boolean useDefaultLogging = false;
        try {
            FileInputStream logFile = new FileInputStream(LOGGING_PROPERTIES_FILENAME);
            try {
                LogManager.getLogManager().readConfiguration(logFile);
            }
            catch (SecurityException e) {
                System.out.println("Unable to read conf/bmp-logging.properties. Using default logging configuration.");
                useDefaultLogging = true;
            }
            catch (IOException e) {
                System.out.println("Unable to read conf/bmp-logging.properties. Using default logging configuration.");
                useDefaultLogging = true;
            }
            finally {
                try {
                    logFile.close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to find conf/bmp-logging.properties. Using default logging configuration.");
            useDefaultLogging = true;
        }
        if (useDefaultLogging) {
            Main.configureDefaultLogger();
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    private static void configureDefaultLogger() {
        Handler[] handlers;
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");
        for (Handler handler : handlers = logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new StandardFormatter());
        handler.setLevel(Level.FINE);
        logger.addHandler(handler);
    }
}

