/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util.prettytime.i18n;

import java.util.ListResourceBundle;
import net.lapismc.afkplus.util.prettytime.Duration;
import net.lapismc.afkplus.util.prettytime.TimeFormat;
import net.lapismc.afkplus.util.prettytime.TimeUnit;
import net.lapismc.afkplus.util.prettytime.impl.TimeFormatProvider;
import net.lapismc.afkplus.util.prettytime.units.Century;
import net.lapismc.afkplus.util.prettytime.units.Day;
import net.lapismc.afkplus.util.prettytime.units.Decade;
import net.lapismc.afkplus.util.prettytime.units.Hour;
import net.lapismc.afkplus.util.prettytime.units.JustNow;
import net.lapismc.afkplus.util.prettytime.units.Millennium;
import net.lapismc.afkplus.util.prettytime.units.Millisecond;
import net.lapismc.afkplus.util.prettytime.units.Minute;
import net.lapismc.afkplus.util.prettytime.units.Month;
import net.lapismc.afkplus.util.prettytime.units.Second;
import net.lapismc.afkplus.util.prettytime.units.Week;
import net.lapismc.afkplus.util.prettytime.units.Year;

public class Resources_kk
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[0][0];

    @Override
    protected Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit t) {
        if (t instanceof JustNow) {
            return new TimeFormat(){

                @Override
                public String format(Duration duration) {
                    return this.performFormat(duration);
                }

                @Override
                public String formatUnrounded(Duration duration) {
                    return this.performFormat(duration);
                }

                private String performFormat(Duration duration) {
                    if (duration.isInFuture()) {
                        return "\u0434\u04d9\u043b \u049b\u0430\u0437\u0456\u0440";
                    }
                    if (duration.isInPast()) {
                        return "\u0436\u0430\u043d\u0430 \u0493\u0430\u043d\u0430";
                    }
                    return null;
                }

                @Override
                public String decorate(Duration duration, String time) {
                    return time;
                }

                @Override
                public String decorateUnrounded(Duration duration, String time) {
                    return time;
                }
            };
        }
        if (t instanceof Century) {
            return new KkTimeFormat("\u0493\u0430\u0441\u044b\u0440", "\u0493\u0430\u0441\u044b\u0440\u0434\u0430\u043d");
        }
        if (t instanceof Day) {
            return new KkTimeFormat("\u043a\u04af\u043d", "\u043a\u04af\u043d\u043d\u0435\u043d");
        }
        if (t instanceof Decade) {
            return new KkTimeFormat("\u043e\u043d\u0436\u044b\u043b\u0434\u044b\u049b", "\u043e\u043d\u0436\u044b\u043b\u0434\u044b\u049b\u0442\u0430\u043d");
        }
        if (t instanceof Hour) {
            return new KkTimeFormat("\u0441\u0430\u0493\u0430\u0442", "\u0441\u0430\u0493\u0430\u0442\u0442\u0430\u043d");
        }
        if (t instanceof Millennium) {
            return new KkTimeFormat("\u043c\u044b\u04a3\u0436\u044b\u043b\u0434\u044b\u049b", "\u043c\u044b\u04a3\u0436\u044b\u043b\u0434\u044b\u049b\u0442\u0430\u043d");
        }
        if (t instanceof Millisecond) {
            return new KkTimeFormat("\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434", "\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u0442\u0430\u043d");
        }
        if (t instanceof Minute) {
            return new KkTimeFormat("\u043c\u0438\u043d\u0443\u0442", "\u043c\u0438\u043d\u0443\u0442\u0442\u0430\u043d");
        }
        if (t instanceof Month) {
            return new KkTimeFormat("\u0430\u0439", "\u0430\u0439\u0434\u0430\u043d");
        }
        if (t instanceof Second) {
            return new KkTimeFormat("\u0441\u0435\u043a\u0443\u043d\u0434", "\u0441\u0435\u043a\u0443\u043d\u0434\u0442\u0430\u043d");
        }
        if (t instanceof Week) {
            return new KkTimeFormat("\u0430\u043f\u0442\u0430", "\u0430\u043f\u0442\u0430\u0434\u0430\u043d");
        }
        if (t instanceof Year) {
            return new KkTimeFormat("\u0436\u044b\u043b", "\u0436\u044b\u043b\u0434\u0430\u043d");
        }
        return null;
    }

    private static class KkTimeFormat
    implements TimeFormat {
        private final int tolerance = 50;
        private final String[] forms;

        public KkTimeFormat(String ... plurals) {
            if (plurals.length != 2) {
                throw new IllegalArgumentException("Future and past forms must be provided for kazakh language!");
            }
            this.forms = plurals;
        }

        @Override
        public String format(Duration duration) {
            long quantity = duration.getQuantityRounded(50);
            StringBuilder result = new StringBuilder();
            result.append(quantity);
            return result.toString();
        }

        @Override
        public String formatUnrounded(Duration duration) {
            long quantity = duration.getQuantity();
            StringBuilder result = new StringBuilder();
            result.append(quantity);
            return result.toString();
        }

        @Override
        public String decorate(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantityRounded(50), time);
        }

        @Override
        public String decorateUnrounded(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantity(), time);
        }

        private String performDecoration(boolean past, boolean future, long n, String time) {
            StringBuilder builder = new StringBuilder();
            int formIndex = past ? 0 : 1;
            builder.append(time);
            builder.append(' ');
            builder.append(this.forms[formIndex]);
            builder.append(' ');
            if (past) {
                builder.append("\u0431\u04b1\u0440\u044b\u043d");
            }
            if (future) {
                builder.append("\u043a\u0435\u0439\u0456\u043d");
            }
            return builder.toString();
        }
    }
}

