/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util.core.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationUtils {
    public String parseLocationToString(Location loc) {
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ() + "," + loc.getPitch() + "," + loc.getYaw();
    }

    public Location parseStringToLocation(String s) {
        Location loc;
        if (s == null || s.equals("")) {
            return null;
        }
        String[] args = s.split(",");
        String worldName = args[0];
        if (Bukkit.getServer().getWorld(worldName) == null) {
            return null;
        }
        World world = Bukkit.getServer().getWorld(worldName);
        try {
            float pitch = Float.parseFloat(args[4]);
            float yaw = Float.parseFloat(args[5]);
            double x = Double.parseDouble(args[1]);
            double y = Double.parseDouble(args[2]);
            double z = Double.parseDouble(args[3]);
            loc = new Location(world, x, y, z, yaw, pitch);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
        return loc;
    }
}

