/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestQueryContext
implements QueryContext {
    private static final String ATTRIBUTE_KEY = WebRequestQueryContext.class.getName() + ".ATTRIBUTE_KEY";
    private static final String JOIN_FETCH_ATTRIBUTE_KEY = WebRequestQueryContext.class.getName() + ".ATTRIBUTE_KEY_JOIN_FETCH";
    private HashMap<String, Function<Root<?>, Join<?, ?>>> contextMap;
    private HashMap<String, Fetch<?, ?>> evaluatedJoinFetch;
    private Map<Pair<String, Root>, Join<?, ?>> rootCache = new HashMap();

    public WebRequestQueryContext(NativeWebRequest request) {
        this.contextMap = (HashMap)request.getAttribute(ATTRIBUTE_KEY, 0);
        if (this.contextMap == null) {
            this.contextMap = new HashMap();
            request.setAttribute(ATTRIBUTE_KEY, this.contextMap, 0);
        }
        this.evaluatedJoinFetch = (HashMap)request.getAttribute(JOIN_FETCH_ATTRIBUTE_KEY, 0);
        if (this.evaluatedJoinFetch == null) {
            this.evaluatedJoinFetch = new HashMap();
            request.setAttribute(JOIN_FETCH_ATTRIBUTE_KEY, this.evaluatedJoinFetch, 0);
        }
    }

    @Override
    public Join<?, ?> getEvaluated(String key, Root<?> root) {
        Function<Root<?>, Join<?, ?>> value = this.contextMap.get(key);
        if (value == null) {
            return null;
        }
        Pair rootKey = Pair.of((Object)key, root);
        if (!this.rootCache.containsKey(rootKey)) {
            Join<?, ?> evaluated = value.apply(root);
            this.rootCache.put((Pair<String, Root>)rootKey, evaluated);
        }
        return this.rootCache.get(rootKey);
    }

    @Override
    public void putLazyVal(String key, Function<Root<?>, Join<?, ?>> value) {
        this.contextMap.put(key, value);
    }

    @Override
    public Fetch<?, ?> getEvaluatedJoinFetch(String key) {
        return this.evaluatedJoinFetch.get(key);
    }

    @Override
    public void putEvaluatedJoinFetch(String key, Fetch<?, ?> fetch) {
        this.evaluatedJoinFetch.put(key, fetch);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextMap == null ? 0 : this.contextMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebRequestQueryContext other = (WebRequestQueryContext)obj;
        return !(this.contextMap == null ? other.contextMap != null : !this.contextMap.equals(other.contextMap));
    }

    public String toString() {
        return "WebRequestQueryContext [contextMap=" + this.contextMap + "]";
    }
}

