/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class Null<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    protected String expectedValue;
    private Converter converter;

    public Null(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("Invalid size of 'httpParamValues' array, Expected 1 but was " + Arrays.toString(httpParamValues));
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (this.converter.convert(this.expectedValue, Boolean.class).booleanValue()) {
            return cb.isNull(this.path(root));
        }
        return cb.isNotNull(this.path(root));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Null aNull = (Null)o;
        return Objects.equals(this.expectedValue, aNull.expectedValue) && Objects.equals(this.converter, aNull.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.expectedValue, this.converter);
    }

    public String toString() {
        return "Null[expectedValue='" + this.expectedValue + '\'' + ", converter=" + this.converter + ", path=" + this.path + ']';
    }
}

