/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.Fake;
import net.kaczmarzyk.spring.data.jpa.utils.JoinPathUtils;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.springframework.data.jpa.domain.Specification;

public class Join<T>
implements Specification<T>,
Fake {
    private static final long serialVersionUID = 1L;
    private String pathToJoinOn;
    private String alias;
    private JoinType joinType;
    private QueryContext queryContext;
    private boolean distinctQuery;

    public Join(QueryContext queryContext, String pathToJoinOn, String alias, JoinType joinType, boolean distinctQuery) {
        this.pathToJoinOn = pathToJoinOn;
        this.alias = alias;
        this.joinType = joinType;
        this.queryContext = queryContext;
        this.distinctQuery = distinctQuery;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        query.distinct(this.distinctQuery);
        if (!JoinPathUtils.pathToJoinContainsAlias(this.pathToJoinOn)) {
            if (!this.queryContext.existsJoin(this.alias, root)) {
                this.queryContext.putLazyVal(this.alias, r -> r.join(this.pathToJoinOn, this.joinType));
            }
        } else {
            String[] pathToJoinOnSplittedByDot = JoinPathUtils.pathToJoinSplittedByDot(this.pathToJoinOn);
            String extractedAlias = pathToJoinOnSplittedByDot[0];
            if (!this.queryContext.existsJoin(extractedAlias, root)) {
                throw new IllegalArgumentException("Join definition with alias: '" + extractedAlias + "' not found! Make sure that join with the alias '" + extractedAlias + "' is defined before the join with path: '" + this.pathToJoinOn + "'");
            }
            String extractedPathToJoin = pathToJoinOnSplittedByDot[1];
            this.queryContext.putLazyVal(this.alias, r -> {
                javax.persistence.criteria.Join<?, ?> evaluated = this.queryContext.getEvaluated(extractedAlias, root);
                return evaluated.join(extractedPathToJoin, this.joinType);
            });
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.distinctQuery, this.joinType, this.pathToJoinOn, this.queryContext);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)obj;
        return Objects.equals(this.alias, other.alias) && this.distinctQuery == other.distinctQuery && this.joinType == other.joinType && Objects.equals(this.pathToJoinOn, other.pathToJoinOn) && Objects.equals(this.queryContext, other.queryContext);
    }

    public String toString() {
        return "Join [pathToJoinOn=" + this.pathToJoinOn + ", alias=" + this.alias + ", joinType=" + this.joinType + ", queryContext=" + this.queryContext + ", distinctQuery=" + this.distinctQuery + "]";
    }
}

