/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.kaczmarzyk.spring.data.jpa.domain.ZeroArgSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestQueryContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class SimpleSpecificationResolver
implements HandlerMethodArgumentResolver {
    SimpleSpecificationResolver() {
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mav, NativeWebRequest req, WebDataBinderFactory binderFactory) throws Exception {
        Spec def = (Spec)param.getParameterAnnotation(Spec.class);
        return this.buildSpecification(req, def);
    }

    Specification<Object> buildSpecification(NativeWebRequest req, Spec def) {
        try {
            Collection<String> args = this.resolveSpecArguments(req, def);
            if (args.isEmpty() && !this.isZeroArgSpec(def)) {
                return null;
            }
            String[] argsArray = args.toArray(new String[args.size()]);
            Specification<Object> spec = this.newSpecification(def, argsArray, req);
            return def.onTypeMismatch().wrap(spec);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Does the specification class expose at least one of the supported constuctors?\nIt can be either:\n  3-arg (QueryContext queryCtx, String path, String[] args)\n  4-arg (QueryContext queryCtx, String path, String[] args, Converter converter)\n  5-arg (QueryContext queryCtx, String path, String[] args, Converter converter, String[] config)", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isZeroArgSpec(Spec def) {
        return ZeroArgSpecification.class.isAssignableFrom(def.spec());
    }

    private Specification<Object> newSpecification(Spec def, String[] argsArray, NativeWebRequest req) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Specification spec;
        WebRequestQueryContext queryCtx = new WebRequestQueryContext(req);
        Converter converter = this.resolveConverter(def);
        if (def.config().length == 0) {
            try {
                spec = def.spec().getConstructor(QueryContext.class, String.class, String[].class).newInstance(queryCtx, def.path(), argsArray);
            }
            catch (NoSuchMethodException e2) {
                spec = def.spec().getConstructor(QueryContext.class, String.class, String[].class, Converter.class).newInstance(queryCtx, def.path(), argsArray, converter);
            }
        } else {
            try {
                spec = def.spec().getConstructor(QueryContext.class, String.class, String[].class, Converter.class, String[].class).newInstance(queryCtx, def.path(), argsArray, converter, def.config());
            }
            catch (NoSuchMethodException e) {
                try {
                    spec = def.spec().getConstructor(QueryContext.class, String.class, String[].class, Converter.class).newInstance(queryCtx, def.path(), argsArray, converter);
                }
                catch (NoSuchMethodException e2) {
                    spec = def.spec().getConstructor(String.class, String[].class, String[].class).newInstance(def.path(), argsArray, def.config());
                }
            }
        }
        return spec;
    }

    private Converter resolveConverter(Spec def) {
        if (def.config().length == 0) {
            return Converter.withTypeMismatchBehaviour(def.onTypeMismatch());
        }
        if (def.config().length == 1) {
            String dateFormat = def.config()[0];
            return Converter.withDateFormat(dateFormat, def.onTypeMismatch());
        }
        throw new IllegalStateException("config should contain only one value -- a date format");
    }

    private Collection<String> resolveSpecArguments(NativeWebRequest req, Spec specDef) {
        if (specDef.constVal().length != 0) {
            return Arrays.asList(specDef.constVal());
        }
        return this.resolveSpecArgumentsFromHttpParameters(req, specDef);
    }

    private Collection<String> resolveSpecArgumentsFromHttpParameters(NativeWebRequest req, Spec specDef) {
        ArrayList<String> args = new ArrayList<String>();
        if (specDef.params().length != 0) {
            for (String webParamName : specDef.params()) {
                String[] httpParamValues = req.getParameterValues(webParamName);
                this.addValuesToArgs(httpParamValues, args);
            }
        } else {
            String[] httpParamValues = req.getParameterValues(specDef.path());
            this.addValuesToArgs(httpParamValues, args);
        }
        return args;
    }

    private void addValuesToArgs(String[] paramValues, Collection<String> args) {
        if (paramValues != null) {
            for (String paramValue : paramValues) {
                if (StringUtils.isEmpty((CharSequence)paramValue)) continue;
                args.add(paramValue);
            }
        }
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(Spec.class);
    }
}

