/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;

public class KeyStoreUtils {
    private KeyStoreUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore load(File keystore, String storetype, String storepass, Provider provider) throws KeyStoreException {
        KeyStore ks;
        if (keystore != null && storetype == null) {
            String filename = keystore.getName().toLowerCase();
            storetype = filename.endsWith(".p12") || filename.endsWith(".pfx") ? "PKCS12" : "JKS";
        }
        try {
            ks = "PKCS11".equals(storetype) ? KeyStore.getInstance(storetype, provider) : KeyStore.getInstance(storetype);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException("keystore type '" + storetype + "' is not supported", e);
        }
        if (keystore == null || !keystore.exists()) {
            throw new KeyStoreException("The keystore " + keystore + " couldn't be found");
        }
        try (FileInputStream in = "PKCS11".equals(storetype) ? null : new FileInputStream(keystore);){
            ks.load(in, storepass != null ? storepass.toCharArray() : null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load the keystore " + keystore, e);
        }
        return ks;
    }
}

