/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PermutationIterator<T>
implements Iterator<List<T>> {
    private final List<T> values = new ArrayList<T>();
    private List<T> next;
    private int[] indices;

    public PermutationIterator(List<T> values) {
        this.values.addAll(values);
        this.initializeIndices(values);
        this.next = values.isEmpty() ? null : new ArrayList<T>(this.values);
    }

    private void initializeIndices(List<T> values) {
        this.indices = new int[values.size()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = i;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public List<T> next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        List<T> current = this.next;
        this.next = this.findNext();
        return current;
    }

    private List<T> findNext() {
        int index = this.nextIndexToChange();
        if (index == -1) {
            return null;
        }
        this.generateNextIndices(index);
        return this.current();
    }

    private int nextIndexToChange() {
        int i;
        for (i = this.indices.length - 2; i >= 0 && this.indices[i] > this.indices[i + 1]; --i) {
        }
        return i;
    }

    private void generateNextIndices(int i) {
        int j;
        int min = this.indices[j];
        int minIndex = j;
        for (j = i + 1; j < this.indices.length; ++j) {
            if (this.indices[i] >= this.indices[j] || this.indices[j] >= min) continue;
            min = this.indices[j];
            minIndex = j;
        }
        PermutationIterator.swap(this.indices, i++, minIndex);
        j = this.indices.length - 1;
        while (i < j) {
            PermutationIterator.swap(this.indices, i++, j--);
        }
    }

    private List<T> current() {
        ArrayList<T> newPermutation = new ArrayList<T>(this.indices.length);
        for (int i : this.indices) {
            newPermutation.add(this.values.get(i));
        }
        return newPermutation;
    }

    private static void swap(int[] array, int a, int b) {
        int tmp = array[a];
        array[a] = array[b];
        array[b] = tmp;
    }
}

