/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import net.jqwik.engine.support.JqwikStreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;

public class JqwikAnnotationSupport {
    public static List<Annotation> findAllAnnotations(AnnotatedElement element) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        List<Annotation> presentAnnotations = Arrays.asList(JqwikAnnotationSupport.getDeclaredAnnotations(element));
        annotations.addAll(presentAnnotations);
        presentAnnotations.forEach(annotation -> JqwikAnnotationSupport.appendMetaAnnotations(annotation, annotations));
        return annotations;
    }

    private static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        if (element instanceof AnnotatedArrayType) {
            return ((AnnotatedArrayType)element).getAnnotatedGenericComponentType().getAnnotations();
        }
        return element.getAnnotations();
    }

    private static void appendMetaAnnotations(Annotation annotation, List<Annotation> collector) {
        Stream<Annotation> metaAnnotationStream = JqwikAnnotationSupport.streamMetaAnnotations(annotation);
        metaAnnotationStream.filter(candidate -> !collector.contains(candidate)).forEach(metaAnnotation -> {
            collector.add((Annotation)metaAnnotation);
            JqwikAnnotationSupport.appendMetaAnnotations(metaAnnotation, collector);
        });
    }

    public static List<Annotation> allMetaAnnotations(Annotation annotation) {
        ArrayList<Annotation> all = new ArrayList<Annotation>();
        Stream<Annotation> metaAnnotationStream = JqwikAnnotationSupport.streamMetaAnnotations(annotation);
        metaAnnotationStream.filter(candidate -> !all.contains(candidate)).forEach(metaAnnotation -> {
            all.add((Annotation)metaAnnotation);
            JqwikAnnotationSupport.appendMetaAnnotations(metaAnnotation, all);
        });
        return all;
    }

    private static Stream<Annotation> streamMetaAnnotations(Annotation annotation) {
        Annotation[] metaAnnotationCandidates = annotation.annotationType().getDeclaredAnnotations();
        return Arrays.stream(metaAnnotationCandidates).filter(candidate -> !JqwikAnnotationSupport.isInJavaLangAnnotationPackage(candidate.annotationType())).filter(candidate -> !JqwikAnnotationSupport.isApiAnnotation(candidate.annotationType()));
    }

    private static boolean isApiAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType == API.class;
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }

    public static <A extends Annotation> List<A> findRepeatableAnnotationOnElementOrContainer(AnnotatedElement element, Class<A> annotationType) {
        AnnotatedElement container;
        ArrayList<A> annotations = new ArrayList<A>(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, annotationType));
        if (element instanceof Member) {
            container = ((Member)((Object)element)).getDeclaringClass();
            annotations.addAll(JqwikAnnotationSupport.findRepeatableAnnotationOnElementOrContainer(container, annotationType));
        }
        if (JqwikAnnotationSupport.isGroup(element)) {
            container = JqwikAnnotationSupport.getGroupContainer((Class)element);
            annotations.addAll(JqwikAnnotationSupport.findRepeatableAnnotationOnElementOrContainer(container, annotationType));
        }
        return annotations;
    }

    private static AnnotatedElement getGroupContainer(Class<?> group) {
        return group.getDeclaringClass();
    }

    private static boolean isGroup(AnnotatedElement element) {
        if (element instanceof Class) {
            return new IsContainerAGroup().test((Class)element);
        }
        return false;
    }

    public static <A extends Annotation> List<A> findContainerAnnotations(Class<?> container, Class<A> annotationType) {
        if (JqwikAnnotationSupport.isRepeatable(annotationType)) {
            ArrayList repeatableAnnotations = new ArrayList(AnnotationSupport.findRepeatableAnnotations(container, annotationType));
            Collections.reverse(repeatableAnnotations);
            return repeatableAnnotations;
        }
        ArrayList collector = new ArrayList();
        JqwikAnnotationSupport.appendContainerAnnotations(container, annotationType, collector);
        return collector;
    }

    private static <A extends Annotation> void appendContainerAnnotations(Class<?> container, Class<A> annotationType, List<A> collector) {
        JqwikAnnotationSupport.findDeclaredAnnotations(container, annotationType).forEach(annotation -> {
            if (!collector.contains(annotation)) {
                collector.add(annotation);
            }
            JqwikAnnotationSupport.appendInheritedAnnotations(container, annotationType, collector);
        });
    }

    private static <A extends Annotation> Stream<A> findDeclaredAnnotations(Class<?> container, Class<A> annotationType) {
        return JqwikStreamSupport.toStream(AnnotationSupport.findAnnotation(container, annotationType));
    }

    private static <A extends Annotation> void appendInheritedAnnotations(Class<?> container, Class<A> annotationType, List<A> collector) {
        if (JqwikAnnotationSupport.isInherited(annotationType)) {
            List<Annotation> inheritedAnnotations = JqwikAnnotationSupport.inheritedAnnotations(container, annotationType);
            for (Annotation inheritedAnnotation : inheritedAnnotations) {
                if (collector.contains(inheritedAnnotation)) continue;
                collector.add(inheritedAnnotation);
            }
        }
    }

    private static <A extends Annotation> List<A> inheritedAnnotations(Class<?> container, Class<A> annotationType) {
        ArrayList inheritedAnnotations = new ArrayList();
        Class<?> superclass = container.getSuperclass();
        if (superclass != null) {
            JqwikAnnotationSupport.appendContainerAnnotations(superclass, annotationType, inheritedAnnotations);
        }
        for (Class<?> anInterface : container.getInterfaces()) {
            JqwikAnnotationSupport.appendContainerAnnotations(anInterface, annotationType, inheritedAnnotations);
        }
        return inheritedAnnotations;
    }

    private static <A extends Annotation> boolean isInherited(Class<A> annotationType) {
        return annotationType.isAnnotationPresent(Inherited.class);
    }

    private static <A extends Annotation> boolean isRepeatable(Class<A> annotationType) {
        return annotationType.isAnnotationPresent(Repeatable.class);
    }
}

