/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.recording;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.engine.recording.TestRun;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.UniqueId;

public class TestRunData {
    private final Collection<TestRun> data;

    public TestRunData(Collection<TestRun> data) {
        this.data = data;
    }

    public TestRunData() {
        this(new LinkedHashSet<TestRun>());
    }

    public void add(TestRun testRun) {
        this.data.add(testRun);
    }

    public Optional<TestRun> byUniqueId(UniqueId uniqueId) {
        try {
            return this.data.stream().filter(testRun -> testRun.hasUniqueId(uniqueId)).findFirst();
        }
        catch (Throwable t) {
            JqwikExceptionSupport.rethrowIfBlacklisted(t);
            return Optional.empty();
        }
    }

    public Stream<TestRun> allNonSuccessfulTests() {
        return this.data.stream().filter(TestRun::isNotSuccessful);
    }
}

