/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;
import net.jqwik.engine.support.JqwikStreamSupport;

public class ShrinkableString
extends ShrinkableContainer<String, Character> {
    public ShrinkableString(List<Shrinkable<Character>> elements, int minSize, int maxSize, Arbitrary<Character> characterArbitrary) {
        super(elements, minSize, maxSize, Collections.emptySet(), characterArbitrary);
    }

    @Override
    String createValue(List<Shrinkable<Character>> shrinkables) {
        StringBuilder builder = new StringBuilder(shrinkables.size());
        for (Shrinkable<Character> shrinkable : shrinkables) {
            builder.appendCodePoint(((Character)shrinkable.value()).charValue());
        }
        return builder.toString();
    }

    @Override
    Shrinkable<String> createShrinkable(List<Shrinkable<Character>> shrunkElements) {
        return new ShrinkableString(shrunkElements, this.minSize, this.maxSize, (Arbitrary<Character>)this.elementArbitrary);
    }

    @Override
    public Stream<Shrinkable<String>> shrink() {
        if (this.elements.size() > 100) {
            return JqwikStreamSupport.concat(this.shrinkSizeAggressively(), this.shrinkSizeOfList(), this.shrinkElementsOneAfterTheOther(100));
        }
        return JqwikStreamSupport.concat(this.shrinkSizeOfList(), this.shrinkElementsOneAfterTheOther(0), this.shrinkPairsOfElements(), this.sortElements());
    }

    private static class CharacterCollector
    implements Collector<Character, StringBuilder, String> {
        private CharacterCollector() {
        }

        @Override
        public Supplier<StringBuilder> supplier() {
            return StringBuilder::new;
        }

        @Override
        public BiConsumer<StringBuilder, Character> accumulator() {
            return StringBuilder::appendCodePoint;
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return StringBuilder::append;
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return StringBuilder::toString;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

