/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.IntRange;
import net.jqwik.api.providers.TypeUsage;

public class IntRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Integer.class);
    }

    public Arbitrary<Integer> configure(Arbitrary<Integer> arbitrary, IntRange range) {
        if (arbitrary instanceof IntegerArbitrary) {
            IntegerArbitrary integerArbitrary = (IntegerArbitrary)arbitrary;
            return integerArbitrary.greaterOrEqual(range.min()).lessOrEqual(range.max());
        }
        return arbitrary.filter(i -> i >= range.min() && i <= range.max());
    }
}

