/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

class BiasedPartitionPointsCalculator {
    BiasedPartitionPointsCalculator() {
    }

    public static List<BigInteger> calculatePartitionPoints(int genSize, BigInteger min, BigInteger max, BigInteger shrinkingTarget) {
        ArrayList<BigInteger> partitions = new ArrayList<BigInteger>();
        if (shrinkingTarget.compareTo(max) >= 0) {
            partitions.addAll(BiasedPartitionPointsCalculator.partitions(min, max, BigInteger.ONE.negate()));
        } else if (shrinkingTarget.compareTo(min) <= 0) {
            partitions.addAll(BiasedPartitionPointsCalculator.partitions(max, min, BigInteger.ONE));
        } else {
            partitions.addAll(BiasedPartitionPointsCalculator.partitions(min, shrinkingTarget, BigInteger.ONE.negate()));
            partitions.addAll(BiasedPartitionPointsCalculator.partitions(max, shrinkingTarget, BigInteger.ONE));
            if (partitions.size() > 0) {
                partitions.add(shrinkingTarget);
            }
        }
        return partitions;
    }

    private static List<BigInteger> partitions(BigInteger from, BigInteger to, BigInteger step) {
        ArrayList<BigInteger> partitions = new ArrayList<BigInteger>();
        BigInteger partitionPoint = from;
        while (true) {
            BigInteger range;
            if ((range = to.subtract(partitionPoint).abs()).compareTo(BigInteger.valueOf(20L)) <= 0) {
                return partitions;
            }
            BigInteger partitionRatio = BiasedPartitionPointsCalculator.partitionRatio(range);
            BigInteger distance = range.divide(partitionRatio);
            BigInteger nextPartitionPoint = to.add(step.multiply(distance));
            if (distance.compareTo(BigInteger.ZERO) == 0) break;
            partitions.add(nextPartitionPoint);
            partitionPoint = nextPartitionPoint;
        }
        return partitions;
    }

    private static BigInteger partitionRatio(BigInteger range) {
        int approximatedDecimals = range.bitLength() / 10 * 3;
        long ratio = Math.max((long)Math.pow((double)approximatedDecimals / 5.0, 10.0), 3L);
        return BigInteger.valueOf(ratio);
    }
}

