/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.support.Combinatorics;

class ListExhaustiveGenerator<T>
implements ExhaustiveGenerator<List<T>> {
    private final Arbitrary<T> elementArbitrary;
    private final Long maxCount;
    private final int minSize;
    private final int maxSize;

    static Optional<Long> calculateMaxCount(Arbitrary<?> elementArbitrary, int minSize, int maxSize, long maxNumberOfSamples) {
        Optional exhaustiveElement = elementArbitrary.exhaustive(maxNumberOfSamples);
        if (!exhaustiveElement.isPresent()) {
            return Optional.empty();
        }
        long elementMaxCount = ((ExhaustiveGenerator)exhaustiveElement.get()).maxCount();
        long sum = 0L;
        for (int n = minSize; n <= maxSize; ++n) {
            double choices = Math.pow(elementMaxCount, n);
            if (choices > (double)maxNumberOfSamples) {
                return Optional.empty();
            }
            sum += (long)choices;
        }
        return Optional.of(sum);
    }

    ListExhaustiveGenerator(Arbitrary<T> elementArbitrary, Long maxCount, int minSize, int maxSize) {
        this.elementArbitrary = elementArbitrary;
        this.maxCount = maxCount;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public Iterator<List<T>> iterator() {
        return Combinatorics.listCombinations((Iterable)this.elementArbitrary.exhaustive().get(), this.minSize, this.maxSize);
    }

    public long maxCount() {
        return this.maxCount;
    }
}

