/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.EdgeCases;

class MappedEdgeCasesConsumer<T, U>
implements Consumer<EdgeCases.Config<U>> {
    private final Consumer<EdgeCases.Config<T>> tConfigurator;
    private final Function<U, T> utMapper;
    private final Function<T, U> tuMapper;

    MappedEdgeCasesConsumer(Consumer<EdgeCases.Config<T>> tConfigurator, Function<U, T> utMapper, Function<T, U> tuMapper) {
        this.tConfigurator = tConfigurator;
        this.utMapper = utMapper;
        this.tuMapper = tuMapper;
    }

    @Override
    public void accept(final EdgeCases.Config<U> uConfig) {
        EdgeCases.Config tConfig = new EdgeCases.Config<T>(){

            public EdgeCases.Config<T> none() {
                uConfig.none();
                return this;
            }

            public EdgeCases.Config<T> filter(Predicate<T> filter) {
                uConfig.filter(u -> filter.test(MappedEdgeCasesConsumer.this.utMapper.apply(u)));
                return this;
            }

            @SafeVarargs
            public final EdgeCases.Config<T> add(T ... edgeCases) {
                for (Object edgeCase : edgeCases) {
                    uConfig.add(new Object[]{MappedEdgeCasesConsumer.this.tuMapper.apply(edgeCase)});
                }
                return this;
            }

            public EdgeCases.Config<T> includeOnly(T ... includedValues) {
                Object[] includedBigIntegers = new Object[includedValues.length];
                for (int i = 0; i < includedValues.length; ++i) {
                    includedBigIntegers[i] = MappedEdgeCasesConsumer.this.tuMapper.apply(includedValues[i]);
                }
                uConfig.includeOnly(includedBigIntegers);
                return this;
            }
        };
        this.tConfigurator.accept(tConfig);
    }
}

