/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.types.TypeUsageImpl;

class RandomizedParameterGenerator {
    private final TypeUsage typeUsage;
    private final List<Arbitrary<Object>> arbitraries;
    private final int genSize;
    private final boolean withEdgeCases;

    RandomizedParameterGenerator(MethodParameter parameter, Set<Arbitrary<Object>> arbitraries, int genSize, boolean withEdgeCases) {
        this.typeUsage = TypeUsageImpl.forParameter(parameter);
        this.arbitraries = new ArrayList<Arbitrary<Object>>(arbitraries);
        this.genSize = genSize;
        this.withEdgeCases = withEdgeCases;
    }

    Shrinkable<Object> next(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
        RandomGenerator<Object> selectedGenerator = this.selectGenerator(random, arbitrariesCache);
        return selectedGenerator.next(random);
    }

    private RandomGenerator<Object> selectGenerator(Random random, Map<TypeUsage, Arbitrary<Object>> arbitrariesCache) {
        if (arbitrariesCache.containsKey(this.typeUsage)) {
            Arbitrary<Object> arbitrary = arbitrariesCache.get(this.typeUsage);
            return this.getGenerator(arbitrary);
        }
        int index = this.arbitraries.size() == 1 ? 0 : random.nextInt(this.arbitraries.size());
        Arbitrary<Object> selectedArbitrary = this.arbitraries.get(index);
        arbitrariesCache.put(this.typeUsage, selectedArbitrary);
        return this.getGenerator(selectedArbitrary);
    }

    private RandomGenerator<Object> getGenerator(Arbitrary<Object> arbitrary) {
        return arbitrary.generator(this.genSize, this.withEdgeCases);
    }
}

