/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundContainerHook;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.engine.hooks.lifecycle.LifecycleMethods;
import net.jqwik.engine.hooks.lifecycle.MethodParameterResolver;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

public class ContainerLifecycleMethodsHook
implements AroundContainerHook {
    public void beforeContainer(ContainerLifecycleContext context) {
        context.optionalContainerClass().ifPresent(containerClass -> {
            List<Method> beforeContainerMethods = LifecycleMethods.findBeforeContainerMethods(containerClass);
            this.callContainerMethods(beforeContainerMethods, context);
        });
    }

    private void callContainerMethods(List<Method> methods, ContainerLifecycleContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(ignore -> false);
        for (Method method : methods) {
            Object[] parameters = MethodParameterResolver.resolveParameters(method, (LifecycleContext)context);
            throwableCollector.execute(() -> this.callStaticMethod(method, parameters));
        }
        throwableCollector.assertEmpty();
    }

    private void callStaticMethod(Method method, Object[] parameters) {
        ReflectionSupport.invokeMethod((Method)method, null, (Object[])parameters);
    }

    public void afterContainer(ContainerLifecycleContext context) {
        context.optionalContainerClass().ifPresent(containerClass -> {
            List<Method> afterContainerMethods = LifecycleMethods.findAfterContainerMethods(containerClass);
            this.callContainerMethods(afterContainerMethods, context);
        });
    }

    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    public boolean appliesTo(Optional<AnnotatedElement> element) {
        return element.map(e -> e instanceof Class).orElse(false);
    }

    public int proximity() {
        return -10;
    }
}

