/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.engine.execution.reporting.LineReporter;
import net.jqwik.engine.execution.reporting.ValueReport;

class CollectionValueReport
extends ValueReport {
    private static final int MAX_LINE_LENGTH = 100;
    private final List<ValueReport> collection;

    CollectionValueReport(Optional<String> label, List<ValueReport> collection) {
        super(label);
        this.collection = collection;
    }

    @Override
    public String singleLineReport() {
        return this.label.orElse("") + "[" + this.singleLineCollection() + "]";
    }

    private String singleLineCollection() {
        return this.collection.stream().map(ValueReport::singleLineReport).collect(Collectors.joining(", "));
    }

    @Override
    public void report(LineReporter lineReporter, int indentLevel, String appendix) {
        lineReporter.addLine(indentLevel, this.label.orElse("") + "[");
        this.reportCollection(lineReporter, indentLevel + 1);
        lineReporter.addLine(indentLevel, "]" + appendix);
    }

    private void reportCollection(LineReporter lineReporter, int indentLevel) {
        String currentLine = "";
        for (int i = 0; i < this.collection.size(); ++i) {
            ValueReport elementReport = this.collection.get(i);
            boolean isNotLastElement = i < this.collection.size() - 1;
            String singleLineElement = elementReport.singleLineReport();
            if (currentLine.length() + singleLineElement.length() + indentLevel * 2 <= 100) {
                currentLine = currentLine + singleLineElement;
                if (!isNotLastElement) continue;
                currentLine = currentLine + ", ";
                continue;
            }
            if (!currentLine.isEmpty()) {
                lineReporter.addLine(indentLevel, currentLine);
                --i;
            } else {
                String optionalComma = isNotLastElement ? "," : "";
                elementReport.report(lineReporter, indentLevel, optionalComma);
            }
            currentLine = "";
        }
        if (!currentLine.isEmpty()) {
            lineReporter.addLine(indentLevel, currentLine);
        }
    }
}

