/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.pipeline;

import java.util.Optional;

public interface TaskExecutionResult {
    public static TaskExecutionResult success() {
        return new TaskExecutionResult(){

            @Override
            public boolean successful() {
                return true;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.empty();
            }

            public String toString() {
                return "TaskExecutionResult(successful)";
            }
        };
    }

    public static TaskExecutionResult failure(final Throwable throwable) {
        return new TaskExecutionResult(){

            @Override
            public boolean successful() {
                return false;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }

            public String toString() {
                return String.format("TaskExecutionResult(failure): %s", throwable.getMessage());
            }
        };
    }

    public boolean successful();

    public Optional<Throwable> throwable();
}

