/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.pipeline.DuplicateExecutionTaskException;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.execution.pipeline.Pipeline;
import net.jqwik.engine.execution.pipeline.PredecessorNotSubmittedException;
import net.jqwik.engine.execution.pipeline.TaskExecutionResult;
import org.junit.platform.engine.UniqueId;

public class ExecutionPipeline
implements Pipeline {
    private final List<ExecutionTask> tasks = new ArrayList<ExecutionTask>();
    private final Map<ExecutionTask, Boolean> taskFinished = new IdentityHashMap<ExecutionTask, Boolean>();
    private final Map<ExecutionTask, ExecutionTask[]> taskPredecessors = new IdentityHashMap<ExecutionTask, ExecutionTask[]>();
    private final PropertyExecutionListener executionListener;

    public ExecutionPipeline(PropertyExecutionListener executionListener) {
        this.executionListener = executionListener;
    }

    @Override
    public void submit(ExecutionTask task, ExecutionTask ... predecessors) {
        if (this.taskFinished.containsKey(task)) {
            throw new DuplicateExecutionTaskException(task);
        }
        this.taskFinished.putIfAbsent(task, false);
        this.taskPredecessors.put(task, predecessors);
        if (!this.taskFinished.get(task).booleanValue()) {
            this.tasks.add(task);
        }
    }

    private void ensurePredecessorsSubmitted(ExecutionTask task, ExecutionTask[] predecessors) {
        for (ExecutionTask predecessor : predecessors) {
            if (this.taskFinished.containsKey(predecessor)) continue;
            throw new PredecessorNotSubmittedException(task, predecessor);
        }
    }

    public void executeFirst(ExecutionTask ... executionTasks) {
        this.executeFirst(Arrays.asList(executionTasks));
    }

    public void executeFirst(UniqueId ownerId) {
        List<ExecutionTask> tasks = this.activeTasksOwnedBy(ownerId);
        this.executeFirst(tasks);
    }

    private List<ExecutionTask> activeTasksOwnedBy(UniqueId ownerId) {
        return this.tasks.stream().filter(task -> this.isSameOrOwner(ownerId, task.ownerId())).collect(Collectors.toList());
    }

    private boolean isSameOrOwner(UniqueId ownerId, UniqueId taskId) {
        List ownerSegments = ownerId.getSegments();
        List taskSegments = taskId.getSegments();
        if (ownerSegments.size() > taskSegments.size()) {
            return false;
        }
        for (int i = 0; i < ownerSegments.size(); ++i) {
            if (((UniqueId.Segment)ownerSegments.get(i)).equals(taskSegments.get(i))) continue;
            return false;
        }
        return true;
    }

    public void executeFirst(List<ExecutionTask> executionTaskList) {
        for (int i = executionTaskList.size() - 1; i >= 0; --i) {
            this.moveToTopOfQueue(executionTaskList.get(i));
        }
    }

    private void moveToTopOfQueue(ExecutionTask task) {
        if (this.tasks.contains(task)) {
            this.tasks.remove(task);
            this.tasks.add(0, task);
        }
    }

    public void runToTermination() {
        TaskExecutionResult predecessorResult = TaskExecutionResult.success();
        while (!this.tasks.isEmpty()) {
            ExecutionTask head = this.tasks.get(0);
            if (this.movedPredecessorsToTopOfQueue(head)) continue;
            predecessorResult = head.execute(this.executionListener, predecessorResult);
            this.taskFinished.put(head, true);
            this.tasks.remove(0);
        }
    }

    private boolean movedPredecessorsToTopOfQueue(ExecutionTask head) {
        ExecutionTask[] predecessors = this.taskPredecessors.get(head);
        this.ensurePredecessorsSubmitted(head, predecessors);
        List<ExecutionTask> unfinishedPredecessors = Arrays.stream(predecessors).filter(predecessor -> this.taskFinished.get(predecessor) == false).collect(Collectors.toList());
        this.executeFirst(unfinishedPredecessors);
        return !unfinishedPredecessors.isEmpty();
    }
}

