/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.MapArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.arbitraries.TraverseArbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequenceArbitrary;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.STABLE, since="1.0")
public class Arbitraries {
    private Arbitraries() {
    }

    public static <T> Arbitrary<T> fromGenerator(RandomGenerator<T> generator) {
        return Arbitraries.fromGeneratorWithSize(ignore -> generator);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8.0")
    public static <T> Arbitrary<T> fromGeneratorWithSize(IntFunction<RandomGenerator<T>> generatorSupplier) {
        return ArbitrariesFacade.implementation.fromGenerator(generatorSupplier);
    }

    public static <T> Arbitrary<T> randomValue(Function<Random, T> generator) {
        IntFunction<RandomGenerator<T>> generatorSupplier = ignore -> random -> Shrinkable.unshrinkable(generator.apply(random));
        return Arbitraries.fromGeneratorWithSize(generatorSupplier);
    }

    public static Arbitrary<Random> randoms() {
        return Arbitraries.randomValue(random -> new Random(random.nextLong()));
    }

    @SafeVarargs
    public static <T> Arbitrary<T> of(T ... values) {
        return Arbitraries.of(Arrays.asList(values));
    }

    @API(status=API.Status.MAINTAINED, since="1.3.1")
    public static <T> Arbitrary<T> of(Collection<T> values) {
        return ArbitrariesFacade.implementation.of(values);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    @SafeVarargs
    public static <T> Arbitrary<T> ofSuppliers(Supplier<T> ... valueSuppliers) {
        return Arbitraries.of(valueSuppliers).map(Supplier::get);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.1")
    public static <T> Arbitrary<T> ofSuppliers(Collection<Supplier<T>> valueSuppliers) {
        return Arbitraries.of(valueSuppliers).map(Supplier::get);
    }

    public static Arbitrary<Character> of(char[] values) {
        return ArbitrariesFacade.implementation.of(values);
    }

    public static <T extends Enum<T>> Arbitrary<T> of(Class<T> enumClass) {
        List<Enum> values = Arrays.asList((Enum[])enumClass.getEnumConstants());
        return Arbitraries.of(values);
    }

    @SafeVarargs
    public static <T> Arbitrary<T> oneOf(Arbitrary<? extends T> first, Arbitrary<? extends T> ... rest) {
        ArrayList<Arbitrary<T>> all = new ArrayList<Arbitrary<T>>();
        all.add(first);
        for (Arbitrary<? extends T> arbitrary : rest) {
            all.add(arbitrary);
        }
        return Arbitraries.oneOf(all);
    }

    public static <T> Arbitrary<T> oneOf(Collection<Arbitrary<? extends T>> choices) {
        if (choices.isEmpty()) {
            String message = "oneOf() must not be called with no choices";
            throw new JqwikException(message);
        }
        if (choices.size() == 1) {
            return choices.iterator().next();
        }
        return ArbitrariesFacade.implementation.oneOf(choices);
    }

    @SafeVarargs
    public static <T> Arbitrary<T> frequency(Tuple.Tuple2<Integer, T> ... frequencies) {
        return Arbitraries.frequency(Arrays.asList(frequencies));
    }

    public static <T> Arbitrary<T> frequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return ArbitrariesFacade.implementation.frequency(frequencies);
    }

    @SafeVarargs
    public static <T> Arbitrary<T> frequencyOf(Tuple.Tuple2<Integer, Arbitrary<? extends T>> ... frequencies) {
        ArrayList<Tuple.Tuple2<Integer, Arbitrary<T>>> all = new ArrayList<Tuple.Tuple2<Integer, Arbitrary<T>>>();
        for (Tuple.Tuple2<Integer, Arbitrary<T>> tuple2 : frequencies) {
            all.add(Tuple.of((Integer)tuple2.get1(), tuple2.get2()));
        }
        return Arbitraries.frequencyOf(all);
    }

    public static <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        return ArbitrariesFacade.implementation.frequencyOf(frequencies);
    }

    public static IntegerArbitrary integers() {
        return ArbitrariesFacade.implementation.integers();
    }

    public static LongArbitrary longs() {
        return ArbitrariesFacade.implementation.longs();
    }

    public static BigIntegerArbitrary bigIntegers() {
        return ArbitrariesFacade.implementation.bigIntegers();
    }

    public static FloatArbitrary floats() {
        return ArbitrariesFacade.implementation.floats();
    }

    public static BigDecimalArbitrary bigDecimals() {
        return ArbitrariesFacade.implementation.bigDecimals();
    }

    public static DoubleArbitrary doubles() {
        return ArbitrariesFacade.implementation.doubles();
    }

    public static ByteArbitrary bytes() {
        return ArbitrariesFacade.implementation.bytes();
    }

    public static ShortArbitrary shorts() {
        return ArbitrariesFacade.implementation.shorts();
    }

    public static StringArbitrary strings() {
        return ArbitrariesFacade.implementation.strings();
    }

    public static CharacterArbitrary chars() {
        return ArbitrariesFacade.implementation.chars();
    }

    @API(status=API.Status.MAINTAINED, since="1.3.2")
    public static <T> Arbitrary<T> just(@Nullable T value) {
        return ArbitrariesFacade.implementation.just(value);
    }

    @API(status=API.Status.MAINTAINED, since="1.1.1")
    public static <T> Arbitrary<T> create(Supplier<T> supplier) {
        return ArbitrariesFacade.implementation.create(supplier);
    }

    @SafeVarargs
    public static <T> Arbitrary<List<T>> shuffle(T ... values) {
        return Arbitraries.shuffle(Arrays.asList(values));
    }

    public static <T> Arbitrary<List<T>> shuffle(List<T> values) {
        return ArbitrariesFacade.implementation.shuffle(values);
    }

    public static <T> Arbitrary<T> defaultFor(Class<T> type, Class<?> ... typeParameters) {
        return ArbitrariesFacade.implementation.defaultFor(type, typeParameters);
    }

    @API(status=API.Status.MAINTAINED, since="1.1")
    public static <T> Arbitrary<T> defaultFor(TypeUsage typeUsage) {
        return Arbitraries.defaultFor(typeUsage, (TypeUsage ignore) -> {
            throw new CannotFindArbitraryException(typeUsage);
        });
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.6.1")
    public static <T> Arbitrary<T> defaultFor(TypeUsage typeUsage, Function<TypeUsage, Arbitrary<Object>> noDefaultResolver) {
        return ArbitrariesFacade.implementation.defaultFor(typeUsage, noDefaultResolver);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static <T> TypeArbitrary<T> forType(Class<T> targetType) {
        return ArbitrariesFacade.implementation.forType(targetType);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.6.1")
    public static <T> TraverseArbitrary<T> traverse(Class<T> targetType, TraverseArbitrary.Traverser traverser) {
        return ArbitrariesFacade.implementation.traverse(targetType, traverser);
    }

    public static <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> arbitrarySupplier) {
        return ArbitrariesFacade.implementation.lazy(arbitrarySupplier);
    }

    public static <T> Arbitrary<T> recursive(Supplier<Arbitrary<T>> base, Function<Arbitrary<T>, Arbitrary<T>> recur, int depth) {
        return ArbitrariesFacade.implementation.recursive(base, recur, depth, depth);
    }

    @API(status=API.Status.MAINTAINED, since="1.6.4")
    public static <T> Arbitrary<T> recursive(Supplier<Arbitrary<T>> base, Function<Arbitrary<T>, Arbitrary<T>> recur, int minDepth, int maxDepth) {
        return ArbitrariesFacade.implementation.recursive(base, recur, minDepth, maxDepth);
    }

    @SafeVarargs
    @API(status=API.Status.MAINTAINED, since="1.3.4")
    public static <T> Arbitrary<T> lazyOf(Supplier<Arbitrary<? extends T>> first, Supplier<Arbitrary<? extends T>> ... rest) {
        ArrayList all = new ArrayList();
        all.add(() -> (Arbitrary)first.get());
        for (Supplier arbitrarySupplier : rest) {
            all.add(() -> (Arbitrary)arbitrarySupplier.get());
        }
        return ArbitrariesFacade.implementation.lazyOf(all);
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <M> ActionSequenceArbitrary<M> sequences(Arbitrary<? extends Action<M>> actionArbitrary) {
        return ArbitrariesFacade.implementation.sequences(actionArbitrary);
    }

    @API(status=API.Status.MAINTAINED, since="1.1.6")
    public static <K, V> MapArbitrary<K, V> maps(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return ArbitrariesFacade.implementation.maps(keysArbitrary, valuesArbitrary);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return ArbitrariesFacade.implementation.entries(keysArbitrary, valuesArbitrary);
    }

    @API(status=API.Status.MAINTAINED, since="1.3.0")
    public static Arbitrary<Void> nothing() {
        return Arbitraries.just(null);
    }

    @API(status=API.Status.MAINTAINED, since="1.6.4")
    public static <T> SetArbitrary<T> subsetOf(Collection<T> values) {
        return Arbitraries.of(values).set();
    }

    @SafeVarargs
    @API(status=API.Status.MAINTAINED, since="1.6.4")
    public static <T> SetArbitrary<T> subsetOf(T ... values) {
        return Arbitraries.subsetOf(Arrays.asList(values));
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitrariesFacade {
        private static final ArbitrariesFacade implementation = FacadeLoader.load(ArbitrariesFacade.class);

        public abstract <T> Arbitrary<T> oneOf(Collection<Arbitrary<? extends T>> var1);

        public abstract <M> ActionSequenceArbitrary<M> sequences(Arbitrary<? extends Action<M>> var1);

        public abstract <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> var1);

        public abstract <T> Arbitrary<T> just(@Nullable T var1);

        public abstract IntegerArbitrary integers();

        public abstract LongArbitrary longs();

        public abstract BigIntegerArbitrary bigIntegers();

        public abstract FloatArbitrary floats();

        public abstract BigDecimalArbitrary bigDecimals();

        public abstract DoubleArbitrary doubles();

        public abstract ByteArbitrary bytes();

        public abstract ShortArbitrary shorts();

        public abstract StringArbitrary strings();

        public abstract CharacterArbitrary chars();

        public abstract <T> Arbitrary<T> defaultFor(Class<T> var1, Class<?>[] var2);

        public abstract <T> Arbitrary<T> defaultFor(TypeUsage var1, Function<TypeUsage, Arbitrary<Object>> var2);

        public abstract <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> var1);

        public abstract <T> TypeArbitrary<T> forType(Class<T> var1);

        public abstract <K, V> MapArbitrary<K, V> maps(Arbitrary<K> var1, Arbitrary<V> var2);

        public abstract <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> var1, Arbitrary<V> var2);

        public abstract <T> Arbitrary<T> recursive(Supplier<Arbitrary<T>> var1, Function<Arbitrary<T>, Arbitrary<T>> var2, int var3, int var4);

        public abstract <T> Arbitrary<T> lazyOf(List<Supplier<Arbitrary<T>>> var1);

        public abstract <T> TraverseArbitrary<T> traverse(Class<T> var1, TraverseArbitrary.Traverser var2);

        public abstract Arbitrary<Character> of(char[] var1);

        public abstract <T> Arbitrary<T> of(Collection<T> var1);

        public abstract <T> Arbitrary<T> create(Supplier<T> var1);

        public abstract <T> Arbitrary<List<T>> shuffle(List<T> var1);

        public abstract <T> Arbitrary<T> fromGenerator(IntFunction<RandomGenerator<T>> var1);

        public abstract <T> Arbitrary<T> frequency(List<Tuple.Tuple2<Integer, T>> var1);
    }
}

