/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.ModifierSupport;

@API(status=API.Status.INTERNAL)
public class LambdaSupport {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private LambdaSupport() {
    }

    public static <T> boolean areEqual(T l1, T l2) {
        if (l1 == l2) {
            return true;
        }
        if (l1.equals(l2)) {
            return true;
        }
        Class<?> l1Class = l1.getClass();
        if (l1Class != l2.getClass()) {
            return false;
        }
        if (l1 instanceof Serializable) {
            try {
                return Arrays.equals(LambdaSupport.serialize(l1), LambdaSupport.serialize(l2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Field field : l1Class.getDeclaredFields()) {
            if (LambdaSupport.fieldIsEqualIn(field, l1, l2)) continue;
            return false;
        }
        return true;
    }

    private static <T> byte[] serialize(T l1) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        outputStream.writeObject(l1);
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean fieldIsEqualIn(Field field, Object left, Object right) {
        try {
            field.setAccessible(true);
            MethodHandle handle = LOOKUP.unreflectGetter(field);
            if (LambdaSupport.isFunctionalType(field.getType())) {
                return LambdaSupport.areEqual(handle.invoke(left), handle.invoke(right));
            }
            return handle.invoke(left).equals(handle.invoke(right));
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isFunctionalType(Class<?> candidateType) {
        if (!candidateType.isInterface()) {
            return false;
        }
        return LambdaSupport.countInterfaceMethods(candidateType) == 1L;
    }

    private static long countInterfaceMethods(Class<?> candidateType) {
        Method[] methods = candidateType.getMethods();
        return LambdaSupport.findInterfaceMethods(methods).size();
    }

    private static List<Method> findInterfaceMethods(Method[] methods) {
        return Arrays.stream(methods).filter(m -> !m.isDefault() && !ModifierSupport.isStatic((Member)m)).collect(Collectors.toList());
    }
}

