/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.statistics.StatisticsEntry;
import net.jqwik.api.statistics.StatisticsReportFormat;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.3.0")
public class Histogram
implements StatisticsReportFormat {
    private static final Logger LOG = Logger.getLogger(Histogram.class.getName());
    static char BOX = (char)9632;

    @Override
    public List<String> formatReport(List<StatisticsEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("Entries must not be empty");
        }
        try {
            entries.sort(this.comparator());
            List<Bucket> buckets = this.cluster(entries);
            return this.generateHistogram(entries, buckets);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "Cannot draw histogram", throwable);
            return Collections.singletonList("Cannot draw histogram: " + throwable);
        }
    }

    protected int maxDrawRange() {
        return 80;
    }

    protected Comparator<? super StatisticsEntry> comparator() {
        return (left, right) -> {
            try {
                Comparable leftFirst = (Comparable)left.values().get(0);
                Comparable rightFirst = (Comparable)right.values().get(0);
                return leftFirst.compareTo(rightFirst);
            }
            catch (ClassCastException castException) {
                return -Integer.compare(left.count(), right.count());
            }
        };
    }

    protected String label(StatisticsEntry entry) {
        return entry.name();
    }

    protected List<Bucket> cluster(List<StatisticsEntry> entries) {
        return entries.stream().map(entry -> new Bucket(this.label((StatisticsEntry)entry), entry.count())).collect(Collectors.toList());
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3.8")
    protected String labelColumnHeader() {
        return "label";
    }

    private List<String> generateHistogram(List<StatisticsEntry> entries, List<Bucket> buckets) {
        int labelWidth = this.calculateLabelWidth(buckets);
        int maxCount = buckets.stream().mapToInt(bucket1 -> ((Bucket)bucket1).count).max().orElse(0);
        int countWidth = this.calculateCountWidth(maxCount);
        double scale = Math.max(1.0, (double)maxCount / (double)this.maxDrawRange());
        ArrayList<String> lines = new ArrayList<String>();
        String headerFormat = "%1$4s | %2$" + labelWidth + "s | %3$" + countWidth + "s | %4$s";
        String bucketFormat = "%1$4s | %2$" + labelWidth + "s | %3$" + countWidth + "d | %4$s";
        lines.add(this.header(headerFormat));
        lines.add(this.ruler(headerFormat));
        for (int i = 0; i < buckets.size(); ++i) {
            Bucket bucket = buckets.get(i);
            lines.add(this.bucketLine(bucketFormat, i, scale, bucket));
        }
        return lines;
    }

    private int calculateCountWidth(int maxCount) {
        int decimals = (int)Math.max(1.0, Math.floor(Math.log10(maxCount)) + 1.0);
        return Math.max(5, decimals);
    }

    private int calculateLabelWidth(List<Bucket> buckets) {
        int maxLabelLength = buckets.stream().mapToInt(bucket -> ((Bucket)bucket).label.length()).max().orElse(0);
        return Math.max(5, maxLabelLength);
    }

    private String bucketLine(String format, int index, double scale, Bucket bucket) {
        String bars = this.bars(bucket.count, scale);
        return String.format(format, index, bucket.label, bucket.count, bars);
    }

    private String bars(int num, double scale) {
        int weight = (int)((double)num / scale);
        return this.multiply(BOX, weight);
    }

    private String multiply(char c, int times) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < times; ++j) {
            builder.append(c);
        }
        return builder.toString();
    }

    private String header(String format) {
        return String.format(format, "#", this.labelColumnHeader(), "count", "");
    }

    private String ruler(String format) {
        String barRuler = this.multiply('-', this.maxDrawRange());
        return String.format(format, "", "", "", barRuler).replace(" ", "-");
    }

    static {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            BOX = (char)35;
        }
    }

    public static class Bucket {
        private final String label;
        private int count = 0;

        public Bucket(String label) {
            this(label, 0);
        }

        public Bucket(String label, int initialCount) {
            if (label == null) {
                throw new IllegalArgumentException("label must not be null");
            }
            this.label = label;
            this.count = initialCount;
        }

        void addCount(int count) {
            this.count += count;
        }
    }
}

