/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.footnotes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.Tuple;
import net.jqwik.api.footnotes.Footnotes;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.PropagationMode;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
class FootnotesHook
implements ResolveParameterHook,
AroundTryHook {
    FootnotesHook() {
    }

    @Override
    public PropagationMode propagateTo() {
        return PropagationMode.ALL_DESCENDANTS;
    }

    @Override
    public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext) {
        if (parameterContext.typeUsage().isOfType(Footnotes.class)) {
            ResolveParameterHook.ParameterSupplier footnotesSupplier = optionalTry -> {
                Tuple.Tuple2 labelAndStore = optionalTry.map(tryLifecycleContext -> Tuple.of(tryLifecycleContext.label(), this.getFootnotesStore())).orElseThrow(() -> {
                    String message = String.format("Illegal argument [%s] in method [%s].%nObjects of type %s can only be injected directly in property methods or in @BeforeTry and @AfterTry lifecycle methods.", parameterContext.parameter(), parameterContext.optionalMethod().map(Method::toString).orElse("unknown"), Footnotes.class);
                    return new IllegalArgumentException(message);
                });
                return new StoreBasedFootnotes(labelAndStore);
            };
            return Optional.of(footnotesSupplier);
        }
        return Optional.empty();
    }

    private Store<List<String>> getFootnotesStore() {
        return Store.getOrCreate(Tuple.of(FootnotesHook.class, "footnotes"), Lifespan.TRY, ArrayList::new);
    }

    @Override
    public TryExecutionResult aroundTry(TryLifecycleContext context, TryExecutor aTry, List<Object> parameters) {
        TryExecutionResult executionResult = aTry.execute(parameters);
        if (executionResult.isFalsified()) {
            List<String> footnotes = this.getFootnotes();
            return executionResult.withFootnotes(footnotes);
        }
        return executionResult;
    }

    @Override
    public int aroundTryProximity() {
        return -20;
    }

    private List<String> getFootnotes() {
        return this.getFootnotesStore().get();
    }

    private static class StoreBasedFootnotes
    implements Footnotes {
        private final String label;
        private final Store<List<String>> store;

        public StoreBasedFootnotes(Tuple.Tuple2<String, Store<List<String>>> labelAndStore) {
            this.label = (String)labelAndStore.get1();
            this.store = labelAndStore.get2();
        }

        @Override
        public void addFootnote(String footnote) {
            this.store.get().add(footnote);
        }

        public String toString() {
            return String.format("%s[%s]", Footnotes.class.getName(), this.label);
        }
    }
}

