/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;

public class FailsafeFuture<T>
extends CompletableFuture<T> {
    private final FailsafeExecutor<T> executor;
    private AbstractExecution execution;
    private Future<?> dependentStageFuture;
    private BiConsumer<Boolean, ExecutionResult> cancelFn;
    private List<Future<T>> timeoutFutures;
    private boolean cancelWithInterrupt;

    FailsafeFuture(FailsafeExecutor<T> executor) {
        this.executor = executor;
    }

    @Override
    public synchronized boolean complete(T value) {
        return this.completeResult(ExecutionResult.success(value));
    }

    @Override
    public synchronized boolean completeExceptionally(Throwable failure) {
        return this.completeResult(ExecutionResult.failure(failure));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelWithInterrupt = mayInterruptIfRunning;
        this.execution.cancelledIndex = Integer.MAX_VALUE;
        boolean cancelResult = super.cancel(mayInterruptIfRunning);
        this.cancelDependencies(mayInterruptIfRunning, null);
        ExecutionResult result = ExecutionResult.failure(new CancellationException());
        super.completeExceptionally(result.getFailure());
        this.executor.handleComplete(result, this.execution);
        return cancelResult;
    }

    synchronized boolean completeResult(ExecutionResult result) {
        if (this.isDone()) {
            return false;
        }
        Throwable failure = result.getFailure();
        boolean completed = failure == null ? super.complete(result.getResult()) : super.completeExceptionally(failure);
        if (completed) {
            this.executor.handleComplete(result, this.execution);
        }
        return completed;
    }

    synchronized List<Future<T>> getTimeoutDelegates() {
        return this.timeoutFutures;
    }

    synchronized void cancelDependencies(boolean mayInterrupt, ExecutionResult cancelResult) {
        this.execution.interrupted = mayInterrupt;
        if (this.dependentStageFuture != null) {
            this.dependentStageFuture.cancel(mayInterrupt);
        }
        if (this.timeoutFutures != null) {
            for (Future<T> timeoutDelegate : this.timeoutFutures) {
                timeoutDelegate.cancel(false);
            }
            this.timeoutFutures.clear();
        }
        if (this.cancelFn != null) {
            this.cancelFn.accept(mayInterrupt, cancelResult);
        }
    }

    void inject(AbstractExecution execution) {
        this.execution = execution;
    }

    synchronized void injectStage(Future<?> dependentStageFuture) {
        if (this.isCancelled()) {
            dependentStageFuture.cancel(this.cancelWithInterrupt);
        } else {
            this.dependentStageFuture = dependentStageFuture;
        }
    }

    synchronized void injectCancelFn(BiConsumer<Boolean, ExecutionResult> cancelFn) {
        this.cancelFn = cancelFn;
    }

    synchronized void injectTimeout(Future<?> timeoutFuture) {
        if (this.timeoutFutures == null) {
            this.timeoutFutures = new ArrayList<Future<T>>(3);
        }
        this.timeoutFutures.add(timeoutFuture);
    }
}

