/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.bundle.processor.renderer;

import java.util.ArrayList;
import java.util.List;
import net.jawr.web.bundle.processor.renderer.RenderedLink;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.AbstractBundleLinkRenderer;

public class BasicBundleRenderer
extends AbstractBundleLinkRenderer {
    private String resourceType;
    private List renderedLinks = new ArrayList();

    public BasicBundleRenderer(ResourceBundlesHandler bundler, String resourceType) {
        this(bundler, resourceType, false);
    }

    public BasicBundleRenderer(ResourceBundlesHandler bundler, String resourceType, boolean useRandomParam) {
        super(bundler, useRandomParam);
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public List getRenderedLinks() {
        return this.renderedLinks;
    }

    protected String renderLink(String fullPath) {
        this.renderedLinks.add(new RenderedLink(fullPath, this.bundler.getConfig().isDebugModeOn()));
        return fullPath;
    }

    protected String createBundleLink(String bundleId, String contextPath) {
        JawrConfig config = this.bundler.getConfig();
        if (config.isDebugModeOn() && config.getGeneratorRegistry().isPathGenerated(bundleId)) {
            bundleId = PathNormalizer.createGenerationPath((String)bundleId, (GeneratorRegistry)config.getGeneratorRegistry());
        }
        String fullPath = PathNormalizer.joinPaths((String)config.getServletMapping(), (String)bundleId);
        fullPath = PathNormalizer.joinPaths((String)contextPath, (String)fullPath);
        return this.renderLink(fullPath);
    }
}

