/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.bundle.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.jawr.web.bundle.processor.renderer.BasicBundleRenderer;
import net.jawr.web.bundle.processor.renderer.RenderedLink;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.ImageResourcesHandler;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.servlet.mock.MockServletConfig;
import net.jawr.web.servlet.mock.MockServletContext;
import net.jawr.web.servlet.mock.MockServletRequest;
import net.jawr.web.servlet.mock.MockServletResponse;
import net.jawr.web.servlet.mock.MockServletSession;
import net.jawr.web.util.FileUtils;
import net.jawr.web.util.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BundleProcessor {
    private static Logger logger;
    private static final String WEB_XML_FILE_PATH = "WEB-INF/web.xml";
    private static final String PARAM_NAME_TAG_NAME = "param-name";
    private static final String PARAM_VALUE_TAG_NAME = "param-value";
    private static final String SERVLET_TAG_NAME = "servlet";
    private static final String SERVLET_CLASS_TAG_NAME = "servlet-class";
    private static final String SERVLET_NAME_TAG_NAME = "servlet-name";
    private static final String INIT_PARAM_TAG_NAME = "init-param";
    private static final String LOAD_ON_STARTUP_TAG_NAME = "load-on-startup";
    private static final String TYPE_INIT_PARAMETER = "type";
    private static final String CDN_DIR_NAME = "/CDN";
    private static final String TEMPLATE_JAWR_APACHE_HTTPD_CONF_PATH = "/net/jawr/web/bundle/resource/template-jawr-apache-httpd.conf";
    private static final String JAWR_APACHE_HTTPD_CONF_FILE = "jawr-apache-httpd.conf";
    private static final String CHECKS_JAWR_JS_SERVLET_MAPPING_EXISTS = "## if <jawr.js.servlet.mapping>";
    private static final String CHECK_JAWR_CSS_SERVLET_MAPPING_EXISTS = "## if <jawr.css.servlet.mapping>";
    private static final String JAWR_IMG_SERVLET_MAPPING_PATTERN = "<jawr\\.img\\.servlet\\.mapping>";
    private static final String JAWR_CSS_SERVLET_MAPPING_PATTERN = "<jawr\\.css\\.servlet\\.mapping>";
    private static final String JAWR_JS_SERVLET_MAPPING_PATTERN = "<jawr\\.js\\.servlet\\.mapping>";
    private static final String APP_ROOT_DIR_PATTERN = "<app\\.root\\.dir>";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.jawr.web.bundle.processor.BundleProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void process(String baseDirPath, String tmpDirPath, String destDirPath, boolean generateCdnFiles) throws Exception {
        this.process(baseDirPath, tmpDirPath, destDirPath, new ArrayList(), generateCdnFiles);
    }

    public void process(String baseDirPath, String tmpDirPath, String destDirPath, List servletsToInitialize, boolean generateCdnFiles) throws Exception {
        URL webAppClasses = new File(String.valueOf(baseDirPath) + "/WEB-INF/classes/").toURL();
        URL webAppLibs = new File(String.valueOf(baseDirPath) + "/WEB-INF/lib/").toURL();
        JawrBundleProcessorCustomClassLoader webAppClassLoader = new JawrBundleProcessorCustomClassLoader(new URL[]{webAppClasses, webAppLibs}, this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(webAppClassLoader);
        File webXml = new File(baseDirPath, WEB_XML_FILE_PATH);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.parse(webXml);
        NodeList servletNodes = doc.getElementsByTagName(SERVLET_TAG_NAME);
        ArrayList<ServletDefinition> servletDefinitions = new ArrayList<ServletDefinition>();
        MockServletContext servletContext = new MockServletContext(baseDirPath, tmpDirPath);
        int i = 0;
        while (i < servletNodes.getLength()) {
            block17: {
                int order;
                MockServletConfig config;
                Class<?> servletClass;
                block16: {
                    String servletName = null;
                    servletClass = null;
                    config = new MockServletConfig(servletContext);
                    order = i;
                    Node servletNode = servletNodes.item(i);
                    HashMap initParameters = new HashMap();
                    NodeList childNodes = servletNode.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Node servletChildNode = childNodes.item(j);
                        if (servletChildNode.getNodeName().equals(SERVLET_NAME_TAG_NAME)) {
                            servletName = servletChildNode.getFirstChild().getNodeValue();
                            config.setServletName(servletName);
                        } else if (servletChildNode.getNodeName().equals(SERVLET_CLASS_TAG_NAME)) {
                            String servletClassName = servletChildNode.getFirstChild().getNodeValue();
                            servletClass = webAppClassLoader.loadClass(servletClassName);
                        } else if (servletChildNode.getNodeName().equals(INIT_PARAM_TAG_NAME)) {
                            this.initializeInitParams(servletChildNode, initParameters);
                        } else if (servletChildNode.getNodeName().equals(LOAD_ON_STARTUP_TAG_NAME)) {
                            order = Integer.parseInt(servletChildNode.getFirstChild().getNodeValue());
                        }
                        ++j;
                    }
                    config.setInitParameters(initParameters);
                    if (servletsToInitialize.contains(servletName)) break block16;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("net.jawr.web.servlet.JawrServlet");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isAssignableFrom(servletClass)) break block17;
                }
                ServletDefinition servletDef = new ServletDefinition(servletClass, config, order);
                servletDefinitions.add(servletDef);
            }
            ++i;
        }
        List jawrServletDefinitions = this.initServlets(servletDefinitions);
        FileUtils.copyDirectory((File)new File(tmpDirPath), (File)new File(destDirPath));
        if (generateCdnFiles) {
            this.processJawrServlets(destDirPath, jawrServletDefinitions);
        }
    }

    private List initServlets(List servletDefinitions) throws Exception {
        Collections.sort(servletDefinitions);
        ThreadLocalJawrContext.setBundleProcessingAtBuildTime((boolean)true);
        ArrayList<ServletDefinition> jawrServletDefinitions = new ArrayList<ServletDefinition>();
        Iterator iterator = servletDefinitions.iterator();
        while (iterator.hasNext()) {
            ServletDefinition servletDefinition = (ServletDefinition)iterator.next();
            servletDefinition.initServlet();
            if (!servletDefinition.isJawrServletDefinition()) continue;
            jawrServletDefinitions.add(servletDefinition);
        }
        return jawrServletDefinitions;
    }

    private void initializeInitParams(Node initParamNode, Map initParameters) {
        String paramName = null;
        String paramValue = null;
        NodeList childNodes = initParamNode.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals(PARAM_NAME_TAG_NAME)) {
                paramName = childNode.getFirstChild().getNodeValue();
            } else if (nodeName.equals(PARAM_VALUE_TAG_NAME)) {
                paramValue = childNode.getFirstChild().getNodeValue();
            }
            ++j;
        }
        initParameters.put(paramName, paramValue);
    }

    private void processJawrServlets(String destDirPath, List jawrServletDefinitions) throws Exception {
        String appRootDir = "";
        String jsServletMapping = "";
        String cssServletMapping = "";
        String imgServletMapping = "";
        String cdnDestDirPath = String.valueOf(destDirPath) + CDN_DIR_NAME;
        Iterator iterator = jawrServletDefinitions.iterator();
        while (iterator.hasNext()) {
            ServletDefinition servletDef = (ServletDefinition)iterator.next();
            ServletConfig servletConfig = servletDef.getServletConfig();
            Map initParameters = ((MockServletConfig)servletConfig).getInitParameters();
            initParameters.remove("jawr.config.reload.interval");
            String servletMapping = servletConfig.getInitParameter("mapping");
            ResourceBundlesHandler bundleHandler = null;
            ImageResourcesHandler imgRsHandler = null;
            ServletContext servletContext = servletConfig.getServletContext();
            String type = servletConfig.getInitParameter(TYPE_INIT_PARAMETER);
            if (type == null || type.equals("js")) {
                int idx;
                bundleHandler = (ResourceBundlesHandler)servletContext.getAttribute("net.jawr.web.resource.bundle.JS_CONTEXT_ATTRIBUTE");
                String contextPathOverride = bundleHandler.getConfig().getContextPathOverride();
                if (StringUtils.isNotEmpty((String)contextPathOverride) && (idx = contextPathOverride.indexOf("//")) != -1 && (idx = contextPathOverride.indexOf("/", idx + 2)) != -1) {
                    appRootDir = PathNormalizer.asPath((String)contextPathOverride.substring(idx));
                }
                if (servletMapping != null) {
                    jsServletMapping = PathNormalizer.asPath((String)servletMapping);
                }
            } else if (type.equals("css")) {
                bundleHandler = (ResourceBundlesHandler)servletContext.getAttribute("net.jawr.web.resource.bundle.CSS_CONTEXT_ATTRIBUTE");
                if (servletMapping != null) {
                    cssServletMapping = PathNormalizer.asPath((String)servletMapping);
                }
            } else if (type.equals("img")) {
                imgRsHandler = (ImageResourcesHandler)servletContext.getAttribute("net.jawr.web.resource.bundle.IMG_CONTEXT_ATTRIBUTE");
                if (servletMapping != null) {
                    imgServletMapping = PathNormalizer.asPath((String)servletMapping);
                }
            }
            if (bundleHandler != null) {
                this.createBundles(servletDef.getServlet(), bundleHandler, cdnDestDirPath, servletMapping);
                continue;
            }
            if (imgRsHandler == null) continue;
            this.createImageBundle(servletDef.getServlet(), imgRsHandler, cdnDestDirPath, servletMapping);
        }
        this.createApacheRewriteConfigFile(cdnDestDirPath, appRootDir, jsServletMapping, cssServletMapping, imgServletMapping);
    }

    private void createApacheRewriteConfigFile(String cdnDestDirPath, String appRootDir, String jsServletMapping, String cssServletMapping, String imgServletMapping) throws IOException {
        BufferedReader templateFileReader = null;
        FileWriter fileWriter = null;
        try {
            templateFileReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(TEMPLATE_JAWR_APACHE_HTTPD_CONF_PATH)));
            fileWriter = new FileWriter(String.valueOf(cdnDestDirPath) + File.separator + JAWR_APACHE_HTTPD_CONF_FILE);
            String line = null;
            boolean processNextString = true;
            while ((line = templateFileReader.readLine()) != null) {
                if (line.startsWith(CHECKS_JAWR_JS_SERVLET_MAPPING_EXISTS)) {
                    if (!StringUtils.isEmpty((String)jsServletMapping)) continue;
                    processNextString = false;
                    continue;
                }
                if (line.startsWith(CHECK_JAWR_CSS_SERVLET_MAPPING_EXISTS)) {
                    if (!StringUtils.isEmpty((String)cssServletMapping)) continue;
                    processNextString = false;
                    continue;
                }
                if (!processNextString) {
                    processNextString = true;
                    continue;
                }
                line = line.replaceAll(APP_ROOT_DIR_PATTERN, appRootDir);
                line = line.replaceAll(JAWR_JS_SERVLET_MAPPING_PATTERN, jsServletMapping);
                line = line.replaceAll(JAWR_CSS_SERVLET_MAPPING_PATTERN, cssServletMapping);
                line = line.replaceAll(JAWR_IMG_SERVLET_MAPPING_PATTERN, imgServletMapping);
                fileWriter.write(String.valueOf(line) + "\n");
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(templateFileReader);
            IOUtils.close(fileWriter);
            throw throwable;
        }
        IOUtils.close((Reader)templateFileReader);
        IOUtils.close((Writer)fileWriter);
    }

    private void createBundles(HttpServlet servlet, ResourceBundlesHandler bundleHandler, String destDirPath, String servletMapping) throws IOException, ServletException {
        List bundles = bundleHandler.getContextBundles();
        Iterator bundleIterator = bundles.iterator();
        MockServletResponse response = new MockServletResponse();
        MockServletRequest request = new MockServletRequest();
        MockServletSession session = new MockServletSession(servlet.getServletContext());
        request.setSession(session);
        String resourceType = servlet.getServletConfig().getInitParameter(TYPE_INIT_PARAMETER);
        if (resourceType == null) {
            resourceType = "js";
        }
        while (bundleIterator.hasNext()) {
            ArrayList<String> localVariantKeys;
            JoinableResourceBundle bundle = (JoinableResourceBundle)bundleIterator.next();
            URL url = servlet.getServletContext().getResource(bundle.getId());
            if (url != null) {
                logger.error((Object)("It is not recommended to use a bundle name which could be in conflict with a resource.\nPlease rename your bundle '" + bundle.getId() + "' to avoid any issue"));
            }
            if ((localVariantKeys = bundle.getLocaleVariantKeys()) == null) {
                localVariantKeys = new ArrayList<String>();
            }
            if (localVariantKeys.isEmpty()) {
                localVariantKeys.add("");
            }
            Iterator iterator = localVariantKeys.iterator();
            while (iterator.hasNext()) {
                String localVariantKey = (String)iterator.next();
                List linksToBundle = this.createLinkToBundle(bundleHandler, bundle.getId(), resourceType, localVariantKey);
                Iterator iteratorLinks = linksToBundle.iterator();
                while (iteratorLinks.hasNext()) {
                    RenderedLink renderedLink = (RenderedLink)iteratorLinks.next();
                    String path = renderedLink.getLink();
                    JawrConfig config = bundleHandler.getConfig();
                    config.setDebugModeOn(renderedLink.isDebugMode());
                    String finalBundlePath = this.getFinalBundlePath(path, config, localVariantKey);
                    File bundleFile = new File(destDirPath, finalBundlePath);
                    this.createBundleFile(servlet, response, request, path, bundleFile, servletMapping);
                }
            }
        }
    }

    public String getFinalBundlePath(String path, JawrConfig jawrConfig, String localVariantKey) {
        String finalPath = path;
        int jawrGenerationParamIdx = finalPath.indexOf("generationConfigParam");
        if (jawrGenerationParamIdx != -1) {
            try {
                finalPath = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException neverHappens) {
                throw new RuntimeException("Something went unexpectedly wrong while decoding a URL for a generator. ", neverHappens);
            }
            finalPath = this.removeServletMappingFromPath(finalPath, jawrConfig.getServletMapping());
            finalPath = jawrConfig.getGeneratorRegistry().getDebugModeBuildTimeGenerationPath(finalPath);
        } else {
            int extensionIndex;
            if ((finalPath = this.removeServletMappingFromPath(finalPath, jawrConfig.getServletMapping())).startsWith("/")) {
                finalPath = finalPath.substring(1);
            }
            if (!jawrConfig.isDebugModeOn()) {
                int idx = finalPath.indexOf("/");
                finalPath = finalPath.substring(idx + 1);
            }
            if (StringUtils.isNotEmpty((String)localVariantKey) && (extensionIndex = FileNameUtils.indexOfExtension((String)finalPath)) != -1) {
                finalPath = String.valueOf(finalPath.substring(0, extensionIndex)) + "_" + localVariantKey + finalPath.substring(extensionIndex);
            }
        }
        return finalPath;
    }

    public String getImageFinalPath(String path, JawrConfig jawrConfig) {
        String finalPath = path;
        if ((finalPath = this.removeServletMappingFromPath(finalPath, jawrConfig.getServletMapping())).startsWith("/")) {
            finalPath = finalPath.substring(1);
        }
        int idx = finalPath.indexOf("/");
        finalPath = finalPath.substring(idx + 1);
        return finalPath;
    }

    private String removeServletMappingFromPath(String path, String mapping) {
        if (mapping != null && mapping.length() > 0) {
            int idx = path.indexOf(mapping);
            if (idx > -1) {
                path = path.substring(idx + mapping.length());
            }
            path = PathNormalizer.asPath((String)path);
        }
        return path;
    }

    private void createImageBundle(HttpServlet servlet, ImageResourcesHandler imgRsHandler, String destDirPath, String servletMapping) throws IOException, ServletException {
        Map bundleImgMap = imgRsHandler.getImageMap();
        Iterator bundleIterator = bundleImgMap.values().iterator();
        MockServletResponse response = new MockServletResponse();
        MockServletRequest request = new MockServletRequest();
        while (bundleIterator.hasNext()) {
            String path = (String)bundleIterator.next();
            String imageFinalPath = this.getImageFinalPath(path, imgRsHandler.getJawrConfig());
            File destFile = new File(destDirPath, imageFinalPath);
            this.createBundleFile(servlet, response, request, path, destFile, servletMapping);
        }
    }

    private void createBundleFile(HttpServlet servlet, MockServletResponse response, MockServletRequest request, String path, File destFile, String mapping) throws IOException, ServletException {
        boolean dirsCreated;
        request.setRequestPath(mapping, path);
        if (!destFile.getParentFile().exists() && !(dirsCreated = destFile.getParentFile().mkdirs())) {
            throw new IOException("The directory '" + destFile.getParentFile().getCanonicalPath() + "' can't be created.");
        }
        try {
            response.setOutputStream(new FileOutputStream(destFile));
            servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            response.close();
        }
        if (destFile.length() == 0L) {
            logger.warn((Object)("No content retrieved for file '" + destFile.getAbsolutePath() + "', which is associated to the path : " + path));
            System.out.println("No content retrieved for file '" + destFile.getAbsolutePath() + "', which is associated to the path : " + path);
        }
    }

    private List createLinkToBundle(ResourceBundlesHandler handler, String path, String resourceType, String variantKey) throws IOException {
        ArrayList<RenderedLink> linksToBundle = new ArrayList<RenderedLink>();
        BasicBundleRenderer bundleRenderer = new BasicBundleRenderer(handler, resourceType);
        StringWriter sw = new StringWriter();
        boolean useGzip = false;
        boolean isSslRequest = false;
        handler.getConfig().setDebugModeOn(false);
        handler.getConfig().setGzipResourcesModeOn(useGzip);
        BundleRendererContext ctx = new BundleRendererContext("", variantKey, useGzip, isSslRequest);
        bundleRenderer.renderBundleLinks(path, ctx, sw);
        handler.getConfig().setDebugModeOn(true);
        ctx = new BundleRendererContext("", variantKey, useGzip, isSslRequest);
        bundleRenderer.renderBundleLinks(path, ctx, sw);
        List renderedLinks = bundleRenderer.getRenderedLinks();
        String contextPathOverride = handler.getConfig().getContextPathOverride();
        Iterator iterator = renderedLinks.iterator();
        while (iterator.hasNext()) {
            RenderedLink renderedLink = (RenderedLink)iterator.next();
            String renderedLinkPath = renderedLink.getLink();
            if (StringUtils.isNotEmpty((String)contextPathOverride) && renderedLinkPath.startsWith(contextPathOverride)) {
                renderedLinkPath = renderedLinkPath.substring(contextPathOverride.length());
            }
            renderedLink.setLink(PathNormalizer.asPath((String)renderedLinkPath));
            linksToBundle.add(renderedLink);
        }
        return linksToBundle;
    }

    private static class JawrBundleProcessorCustomClassLoader
    extends URLClassLoader {
        public JawrBundleProcessorCustomClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public URL findResource(String name) {
            URL url = super.findResource(name);
            if (url == null && name.startsWith("/")) {
                url = super.findResource(name.substring(1));
            }
            return url;
        }
    }

    private static class ServletDefinition
    implements Comparable {
        private HttpServlet servlet;
        private Class servletClass;
        private ServletConfig servletConfig;
        private int order;

        public ServletDefinition() {
        }

        public ServletDefinition(Class servletClass, ServletConfig servletConfig, int order) {
            this.servletClass = servletClass;
            this.servletConfig = servletConfig;
            this.order = order;
        }

        public Class getServletClass() {
            return this.servletClass;
        }

        public void setServletClass(Class servletClass) {
            this.servletClass = servletClass;
        }

        public HttpServlet getServlet() {
            return this.servlet;
        }

        public void setServlet(HttpServlet servlet) {
            this.servlet = servlet;
        }

        public ServletConfig getServletConfig() {
            return this.servletConfig;
        }

        public void setServletConfig(ServletConfig servletConfig) {
            this.servletConfig = servletConfig;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public HttpServlet initServlet() throws Exception {
            this.servlet = (HttpServlet)this.servletClass.newInstance();
            this.servlet.init(this.servletConfig);
            return this.servlet;
        }

        public boolean isJawrServletDefinition() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("net.jawr.web.servlet.JawrServlet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.isAssignableFrom(this.servletClass);
        }

        public int compareTo(Object arg0) {
            return this.order - ((ServletDefinition)arg0).order;
        }
    }
}

