/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import org.jspecify.annotations.Nullable;

abstract class AbstractSpringMatcher {
    private final Configuration configuration;
    private final Consumer<InternalMatcher> matcher;
    private final Function<@Nullable Object, Object> jsonTransformer;

    AbstractSpringMatcher(Configuration configuration, Consumer<InternalMatcher> matcher, Function<@Nullable Object, Object> jsonTransformer) {
        this.configuration = configuration;
        this.matcher = matcher;
        this.jsonTransformer = jsonTransformer;
    }

    void doMatch(@Nullable Object actual) {
        Object json = this.jsonTransformer.apply(actual);
        String pathPrefix = JsonUtils.getPathPrefix((Object)json);
        Path path = Path.create((String)"", (String)pathPrefix);
        this.matcher.accept(new InternalMatcher(json, path, "", this.configuration));
    }
}

