/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final Path path;
    final Configuration configuration;

    AbstractSpringMatchers(Path path, Configuration configuration) {
        this.path = path;
        this.configuration = configuration;
    }

    abstract MATCHER matcher(BiConsumer<Object, InternalMatcher> var1);

    abstract ME matchers(Path var1, Configuration var2);

    public ME node(String newPath) {
        return this.matchers(this.path.copy(newPath), this.configuration);
    }

    public ME ignoring(String ignorePlaceholder) {
        return this.matchers(this.path, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public ME withTolerance(BigDecimal tolerance) {
        return this.matchers(this.path, this.configuration.withTolerance(tolerance));
    }

    public ME withDifferenceListener(DifferenceListener differenceListener) {
        return this.matchers(this.path, this.configuration.withDifferenceListener(differenceListener));
    }

    public ME when(Option firstOption, Option ... otherOptions) {
        return this.matchers(this.path, this.configuration.withOptions(firstOption, otherOptions));
    }

    public MATCHER isEqualTo(Object expected) {
        return this.matcher((actual, ctx) -> ctx.isEqualTo(expected));
    }

    public MATCHER isStringEqualTo(String expected) {
        return this.matcher((actual, ctx) -> ctx.isStringEqualTo(expected));
    }

    public MATCHER isNotEqualTo(Object expected) {
        return this.matcher((actual, ctx) -> ctx.isNotEqualTo(expected));
    }

    public MATCHER isAbsent() {
        return this.matcher((actual, ctx) -> ctx.isAbsent());
    }

    public MATCHER isPresent() {
        return this.matcher((actual, ctx) -> ctx.isPresent());
    }

    public MATCHER isArray() {
        return this.matcher((actual, ctx) -> ctx.isArray());
    }

    public MATCHER isObject() {
        return this.matcher((actual, ctx) -> ctx.isObject());
    }

    public MATCHER isString() {
        return this.matcher((actual, ctx) -> ctx.isString());
    }

    public MATCHER isNull() {
        return this.matcher((actual, ctx) -> ctx.isNull());
    }

    public MATCHER isNotNull() {
        return this.matcher((actual, ctx) -> ctx.isNotNull());
    }

    public MATCHER matches(Matcher<?> matcher) {
        return this.matcher((actual, ctx) -> ctx.matches(matcher));
    }

    public MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    public MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

