/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.spring.AbstractMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final String path;
    final Configuration configuration;

    AbstractSpringMatchers(String path, Configuration configuration) {
        this.path = path;
        this.configuration = configuration;
    }

    abstract MATCHER matcher(BiConsumer<Object, AbstractMatcher> var1);

    abstract ME matchers(String var1, Configuration var2);

    public ME node(String path) {
        return this.matchers(path, this.configuration);
    }

    public ME ignoring(String ignorePlaceholder) {
        return this.matchers(this.path, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public ME withTolerance(BigDecimal tolerance) {
        return this.matchers(this.path, this.configuration.withTolerance(tolerance));
    }

    public ME withDifferenceListener(DifferenceListener differenceListener) {
        return this.matchers(this.path, this.configuration.withDifferenceListener(differenceListener));
    }

    public ME when(Option firstOption, Option ... otherOptions) {
        return this.matchers(this.path, this.configuration.withOptions(firstOption, otherOptions));
    }

    public MATCHER isEqualTo(Object expected) {
        return this.matcher((actual, ctx) -> {
            Diff diff = ctx.createDiff(expected, actual);
            diff.failIfDifferent();
        });
    }

    public MATCHER isStringEqualTo(String expected) {
        return this.matcher((actual, ctx) -> {
            ctx.isString(actual);
            Node node = ctx.getNode(actual);
            if (!node.asText().equals(expected)) {
                ctx.failOnDifference(Diff.quoteTextValue((Object)expected), Diff.quoteTextValue((Object)node.asText()));
            }
        });
    }

    public MATCHER isNotEqualTo(Object expected) {
        return this.matcher((actual, ctx) -> {
            Diff diff = ctx.createDiff(expected, actual);
            if (diff.similar()) {
                AbstractMatcher.failWithMessage("JSON is equal.");
            }
        });
    }

    public MATCHER isAbsent() {
        return this.matcher((actual, ctx) -> {
            if (!JsonUtils.nodeAbsent((Object)actual, (String)this.path, (Configuration)this.configuration)) {
                ctx.failOnDifference("node to be absent", Diff.quoteTextValue((Object)JsonUtils.getNode((Object)actual, (String)this.path)));
            }
        });
    }

    public MATCHER isPresent() {
        return this.matcher((actual, ctx) -> ctx.isPresent(actual));
    }

    public MATCHER isArray() {
        return this.matcher((actual, ctx) -> {
            ctx.isPresent(actual);
            Node node = ctx.getNode(actual);
            if (node.getNodeType() != Node.NodeType.ARRAY) {
                ctx.failOnType(node, "an array");
            }
        });
    }

    public MATCHER isObject() {
        return this.matcher((actual, ctx) -> {
            ctx.isPresent(actual);
            Node node = ctx.getNode(actual);
            if (node.getNodeType() != Node.NodeType.OBJECT) {
                ctx.failOnType(node, "an object");
            }
        });
    }

    public MATCHER isString() {
        return this.matcher((actual, ctx) -> ctx.isString(actual));
    }

    public MATCHER isNull() {
        return this.matcher((actual, ctx) -> ctx.isNull(actual));
    }

    public MATCHER isNotNull() {
        return this.matcher((actual, ctx) -> ctx.isNotNull(actual));
    }

    public MATCHER matches(Matcher<?> matcher) {
        return this.matcher((actual, ctx) -> {
            ctx.isPresent(actual);
            Node node = ctx.getNode(actual);
            MatcherAssert.assertThat((String)("Node \"" + this.path + "\" does not match."), (Object)node.getValue(), (Matcher)matcher);
        });
    }

    public MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    public MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

