/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;

abstract class AbstractMatcher {
    private final String path;
    private final Configuration configuration;
    private final BiConsumer<Object, AbstractMatcher> matcher;

    AbstractMatcher(String path, Configuration configuration, BiConsumer<Object, AbstractMatcher> matcher) {
        this.path = path;
        this.configuration = configuration;
        this.matcher = matcher;
    }

    Diff createDiff(Object expected, Object actual) {
        return Diff.create((Object)expected, (Object)actual, (String)"actual", (String)this.path, (Configuration)this.configuration);
    }

    void isPresent(Object actual) {
        if (JsonUtils.nodeAbsent((Object)actual, (String)this.path, (Configuration)this.configuration)) {
            this.failOnDifference("node to be present", "missing");
        }
    }

    void failOnType(Node node, String type) {
        AbstractMatcher.failWithMessage("Node \"" + this.path + "\" has invalid type, expected: <" + type + "> but was: <" + Diff.quoteTextValue((Object)node.getValue()) + ">.");
    }

    Node getNode(Object actual) {
        return JsonUtils.getNode((Object)actual, (String)this.path);
    }

    void isString(Object actual) {
        this.isPresent(actual);
        Node node = this.getNode(actual);
        if (node.getNodeType() != Node.NodeType.STRING) {
            this.failOnType(node, "a string");
        }
    }

    void isNull(Object actual) {
        this.isPresent(actual);
        Node node = this.getNode(actual);
        if (node.getNodeType() != Node.NodeType.NULL) {
            this.failOnType(node, "a null");
        }
    }

    void isNotNull(Object actual) {
        this.isPresent(actual);
        Node node = this.getNode(actual);
        if (node.getNodeType() == Node.NodeType.NULL) {
            this.failOnType(node, "not null");
        }
    }

    void doMatch(Object actual) {
        this.matcher.accept(actual, this);
    }

    static void failWithMessage(String message) {
        throw new AssertionError((Object)message);
    }

    void failOnDifference(Object expected, Object actual) {
        AbstractMatcher.failWithMessage(String.format("Different value found in node \"%s\", expected: <%s> but was: <%s>.", this.path, expected, actual));
    }
}

