/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.BiConsumer;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final Path path;
    final Configuration configuration;

    AbstractSpringMatchers(@NotNull Path path, @NotNull Configuration configuration) {
        this.path = path;
        this.configuration = configuration;
    }

    @NotNull
    abstract MATCHER matcher(@NotNull BiConsumer<Object, InternalMatcher> var1);

    @NotNull
    abstract ME matchers(@NotNull Path var1, @NotNull Configuration var2);

    @NotNull
    public ME node(String newPath) {
        return this.matchers(this.path.copy(newPath), this.configuration);
    }

    @NotNull
    public ME ignoring(@NotNull String ignorePlaceholder) {
        return this.matchers(this.path, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    @NotNull
    public ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    @NotNull
    public ME withTolerance(@Nullable BigDecimal tolerance) {
        return this.matchers(this.path, this.configuration.withTolerance(tolerance));
    }

    @NotNull
    public ME withDifferenceListener(@NotNull DifferenceListener differenceListener) {
        return this.matchers(this.path, this.configuration.withDifferenceListener(differenceListener));
    }

    @NotNull
    public ME when(@NotNull Option firstOption, Option ... otherOptions) {
        return this.matchers(this.path, this.configuration.withOptions(firstOption, otherOptions));
    }

    @NotNull
    public MATCHER isEqualTo(@Nullable Object expected) {
        return this.matcher((actual, ctx) -> ctx.isEqualTo(expected));
    }

    @NotNull
    public MATCHER isStringEqualTo(@Nullable String expected) {
        return this.matcher((actual, ctx) -> ctx.isStringEqualTo(expected));
    }

    @NotNull
    public MATCHER isNotEqualTo(@Nullable Object expected) {
        return this.matcher((actual, ctx) -> ctx.isNotEqualTo(expected));
    }

    @NotNull
    public MATCHER isAbsent() {
        return this.matcher((actual, ctx) -> ctx.isAbsent());
    }

    @NotNull
    public MATCHER isPresent() {
        return this.matcher((actual, ctx) -> ctx.isPresent());
    }

    @NotNull
    public MATCHER isArray() {
        return this.matcher((actual, ctx) -> ctx.isArray());
    }

    @NotNull
    public MATCHER isObject() {
        return this.matcher((actual, ctx) -> ctx.isObject());
    }

    @NotNull
    public MATCHER isString() {
        return this.matcher((actual, ctx) -> ctx.isString());
    }

    @NotNull
    public MATCHER isNull() {
        return this.matcher((actual, ctx) -> ctx.isNull());
    }

    @NotNull
    public MATCHER isNotNull() {
        return this.matcher((actual, ctx) -> ctx.isNotNull());
    }

    @NotNull
    public MATCHER matches(@NotNull Matcher<?> matcher) {
        return this.matcher((actual, ctx) -> ctx.matches(matcher));
    }

    @NotNull
    public MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    @NotNull
    public MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

