/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import org.assertj.core.api.AbstractAssert;
import org.codehaus.jackson.JsonNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAssert
extends AbstractAssert<JsonAssert, JsonNode> {
    private static final String EXPECTED = "expected";
    private static final String ACTUAL = "actual";
    private static String ignorePlaceholder = "${json-unit.ignore}";
    private final String path;

    protected JsonAssert(JsonNode actual, String path) {
        super((Object)actual, JsonAssert.class);
        this.path = path;
    }

    public static JsonAssert assertThatJson(JsonNode json) {
        return new JsonAssert(json, "");
    }

    public static JsonAssert assertThatJson(Object json) {
        return JsonAssert.assertThatJson(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonAssert isEqualTo(JsonNode expected) {
        this.isNotNull();
        Diff diff = new Diff(expected, (JsonNode)this.actual, this.path, ignorePlaceholder);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences(), new Object[0]);
        }
        return this;
    }

    public JsonAssert isEqualTo(Object expected) {
        return this.isEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert isNotEqualTo(JsonNode expected) {
        this.isNotNull();
        Diff diff = new Diff(expected, (JsonNode)this.actual, this.path, ignorePlaceholder);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.", new Object[0]);
        }
        return this;
    }

    public JsonAssert isNotEqualTo(Object expected) {
        return this.isNotEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert hasSameStructureAs(JsonNode expected) {
        this.isNotNull();
        Diff diff = new Diff(expected, (JsonNode)this.actual, this.path, ignorePlaceholder);
        if (!diff.similarStructure()) {
            this.failWithMessage(diff.structureDifferences(), new Object[0]);
        }
        return this;
    }

    public JsonAssert hasSameStructureAs(Object expected) {
        return this.hasSameStructureAs(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonAssert node(String path) {
        return new JsonAssert((JsonNode)this.actual, path);
    }

    public JsonAssert isIn(Object ... values) {
        throw new UnsupportedOperationException("isIn assertion is not yet supported.");
    }

    public JsonAssert isIn(Iterable<?> values) {
        throw new UnsupportedOperationException("isIn assertion is not yet supported.");
    }

    public JsonAssert isNotIn(Object ... values) {
        throw new UnsupportedOperationException("isNotIn assertion is not yet supported.");
    }

    public JsonAssert isNotIn(Iterable<?> values) {
        throw new UnsupportedOperationException("isNotIn assertion is not yet supported.");
    }

    public static void setIgnorePlaceholder(String ignorePlaceholder) {
        JsonAssert.ignorePlaceholder = ignorePlaceholder;
    }

    public static String getIgnorePlaceholder() {
        return ignorePlaceholder;
    }
}

