/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springjava;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.javacrumbs.futureconverter.common.FutureWrapper;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.ListenableFutureCallbackRegistry;

class ListenableCompletableFutureWrapper<T>
extends FutureWrapper<T>
implements ListenableFuture<T> {
    private final ListenableFutureCallbackRegistry<T> callbackRegistry = new ListenableFutureCallbackRegistry();

    ListenableCompletableFutureWrapper(CompletableFuture<T> wrapped) {
        super(wrapped);
        wrapped.whenComplete((result, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    this.callbackRegistry.failure(ex.getCause());
                } else {
                    this.callbackRegistry.failure(ex);
                }
            } else {
                this.callbackRegistry.success(result);
            }
        });
    }

    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.callbackRegistry.addCallback(callback);
    }

    public CompletableFuture<T> getWrappedFuture() {
        return (CompletableFuture)super.getWrappedFuture();
    }
}

